#ifndef ZEERECIPEVIEWWINDOW_H
#define ZEERECIPEVIEWWINDOW_H

#include "zeemodalwindow.h"

class Ir;

class QTextView;
class QToolButton;

class ZeeRecipeViewWindow : public ZeeModalWindow
{
    Q_OBJECT
    
public:
    ZeeRecipeViewWindow(int recipeId, QWidget* parent = 0, const char* name = 0);
    ~ZeeRecipeViewWindow();

    void updateView();

private slots:
    void editRecipe();
    void removeRecipe();
    void beamRecipe();
    void beamRecipeDone(Ir*);
    
private:
    int m_recipeId;

    QToolButton* m_pEditRecipeButton;
    QToolButton* m_pRemoveRecipeButton;
    QToolButton* m_pBeamRecipeButton;
    
    QTextView* m_pTextView;
};

#endif // ZEERECIPEVIEWWINDOW_H
