#include "zeerecipelistview.h"

#include "sql/qsqldatabase.h"
#include "sql/qsqlquery.h"

ZeeRecipeListViewItem::ZeeRecipeListViewItem(int recipeId, QString name, QListView* parent)
    : QListViewItem(parent)
{
    m_recipeId = recipeId;

    setText(0, name);
}

ZeeRecipeListViewItem::~ZeeRecipeListViewItem()
{
}

int ZeeRecipeListViewItem::recipeId() const
{
    return m_recipeId;
}

ZeeRecipeListView::ZeeRecipeListView(QWidget* parent, const char* name)
    : ZeeListView(parent, name)
{
    setAllColumnsShowFocus(true);
    addColumn(tr("Recipe"));

    updateView();
}

ZeeRecipeListView::~ZeeRecipeListView()
{
}

void ZeeRecipeListView::setFilter(QString filter)
{
    m_filter = filter;
}

QString ZeeRecipeListView::filter() const
{
    return m_filter;
}

void ZeeRecipeListView::updateView()
{
    blockSignals(true);

    int selectedId = selected();

    clear();

    QSqlDatabase* database = QSqlDatabase::database(QSqlDatabase::defaultConnection, false);

    if (database->isOpen()) {
        QString queryString = "SELECT id, name FROM recipe";

        if (!m_filter.isNull()) {
            queryString += " WHERE " + m_filter;
        }

        QSqlQuery query(queryString);

        while (query.next()) {
            int id = query.value(0).toInt();
            QString name = query.value(1).toString();

            new ZeeRecipeListViewItem(id, name, this);
        }
    }

    if (selectedId != -1) {
        select(selectedId);
    }

    blockSignals(false);
}

void ZeeRecipeListView::select(int recipeId)
{
    ZeeRecipeListViewItem* item = (ZeeRecipeListViewItem*)firstChild();

    while (item) {
        if (item->recipeId() == recipeId) {
            setSelected(item, true);
            ensureItemVisible(item);
            break;
        }

        item = (ZeeRecipeListViewItem*)(item->nextSibling());
    }
}

int ZeeRecipeListView::selected() const
{
    int recipeId;

    ZeeRecipeListViewItem* item = (ZeeRecipeListViewItem*)selectedItem();

    if (item) {
        recipeId = item->recipeId();
    } else {
        recipeId = -1;
    }

    return recipeId;
}
