#include "zeeprogressdialog.h"

#include <qapplication.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qprogressbar.h>

ZeeProgressDialog::ZeeProgressDialog(QWidget* parent, const char* name)
    : QWidget(parent, name, WType_Modal | WType_TopLevel | WStyle_Dialog)
{
    setCaption(tr("Progress"));

    m_pLabel = new QLabel(this);
    m_pProgressBar = new QProgressBar(this);

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);

    mainLayout->addWidget(m_pLabel);
    mainLayout->addWidget(m_pProgressBar);
}

ZeeProgressDialog::~ZeeProgressDialog()
{
}

void ZeeProgressDialog::show()
{
    setFixedSize(sizeHint());

    QWidget* widget = parentWidget();
    QPoint point(0, 0);

    if (widget) {
        point = widget->mapToGlobal(point);
    } else {
        widget = QApplication::desktop();
    }

    move(point.x() + widget->width() / 2  - width() / 2,
         point.y() + widget->height() / 2 - height() / 2);

    QWidget::show();

    qApp->processEvents();
}

QSize ZeeProgressDialog::sizeHint() const
{
    QSize labelSize = m_pLabel->sizeHint();
    QSize progressBarSize = m_pProgressBar->sizeHint();

    return QSize(QMAX(labelSize.width() + 2 * 4, 127),
                 labelSize.height() + progressBarSize.height() + 3 * 4);
}

void ZeeProgressDialog::setLabelText(const QString& text)
{
    m_pLabel->setText(text);

    setFixedSize(sizeHint());
}

void ZeeProgressDialog::setProgress(int progress)
{
    m_pProgressBar->setProgress(progress);
}

void ZeeProgressDialog::setTotalSteps(int totalSteps)
{
    m_pProgressBar->setTotalSteps(totalSteps);
}
