#include "zeenewdialog.h"

#include <qpe/storage.h>

#include <qcombobox.h>
#include <qdir.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

ZeeNewDialog::ZeeNewDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    setCaption(tr("New Cookbook"));

    QLabel* nameLabel = new QLabel(tr("Name:"), this);

    m_pNameLineEdit = new QLineEdit(this);
    connect(m_pNameLineEdit, SIGNAL(returnPressed()), this, SLOT(accept()));

    QLabel* locationLabel = new QLabel(tr("Location:"), this);
    
    m_pLocationComboBox = new QComboBox(this);

    StorageInfo storageInfo;
    const QList<FileSystem>& fileSystemList = storageInfo.fileSystems();
    QListIterator<FileSystem> it(fileSystemList);

    QString hardDiskHome;
    QString hardDiskPath;

    for (; it.current(); ++it) {
        if (it.current()->isRemovable()) {
            m_locationList.append(it.current()->path());
            m_pLocationComboBox->insertItem(it.current()->name());
        } else if ((it.current()->disk() == "/dev/mtdblock1") || it.current()->disk() == "/dev/mtdblock/1") {
            m_locationList.append(QDir::homeDirPath());
            m_pLocationComboBox->insertItem(it.current()->name());
        } else if (it.current()->name().contains("Hard Disk") && QDir::homeDirPath().contains(it.current()->path()) && (it.current()->path().length() > hardDiskHome.length())) {
            hardDiskPath = QDir::homeDirPath();
            hardDiskHome = it.current()->name();
        }
    }

    if (!hardDiskHome.isEmpty()) {
        m_locationList.append(hardDiskPath);
        m_pLocationComboBox->insertItem(hardDiskHome);
    }

    QGridLayout* mainLayout = new QGridLayout(this, 2, 2, 4, 4);

    mainLayout->addWidget(nameLabel, 0, 0);
    mainLayout->addWidget(m_pNameLineEdit, 0, 1);
    mainLayout->addWidget(locationLabel, 1, 0);
    mainLayout->addWidget(m_pLocationComboBox, 1, 1);
}

ZeeNewDialog::~ZeeNewDialog()
{
}

QString ZeeNewDialog::selectedName() const
{
    return m_pNameLineEdit->text();
}

QString ZeeNewDialog::selectedLocation() const
{
    return m_locationList[m_pLocationComboBox->currentItem()];
}
