#include "zeemodalwindow.h"

#include <qapplication.h>

ZeeModalWindow::ZeeModalWindow(QWidget* parent, const char* name)
    : QWidget(parent, name, Qt::WType_Modal | Qt::WType_TopLevel)
{
    inLoop = false;
}

ZeeModalWindow::~ZeeModalWindow()
{
    hide();
}

void ZeeModalWindow::hide()
{
    QWidget::hide();

    if (inLoop) {
        inLoop = false;
        qApp->exit_loop();
    }
}

void ZeeModalWindow::exec()
{
    show();

    if (!inLoop) {
        inLoop = true;
        qApp->enter_loop();
    }
}
