#ifndef ZEEMAINWINDOW_H
#define ZEEMAINWINDOW_H

#include <qwidget.h>

class ZeeRecipeListView;

class QSqlDatabase;

class Ir;

class QLabel;
class QTextStream;
class QToolButton;

class ZeeMainWindow : public QWidget
{
    Q_OBJECT

public:
    ZeeMainWindow(QWidget* parent = 0, const char* name = 0);
    ~ZeeMainWindow();
    
    void updateView();

public slots:
    void setDocument(const QString& fileName);

private slots:
    void startup();

    void newCookbook();
    void openLastCookbook();
    void openCookbook();

    void addRecipe();
    
    void pressRecipe(int button);
    void showRecipePopupMenu();
    
    void viewRecipe();
    void editRecipe();
    void removeRecipe();
    void beamRecipe();
    void beamRecipeDone(Ir*);
    
    void searchTool();
    void showAllTool();
    void importTool();
    void exportTool();

private:
    QSqlDatabase* m_pDatabase;

    QToolButton* m_pNewCookbookButton;
    QToolButton* m_pOpenCookbookButton;
    
    QToolButton* m_pAddRecipeButton;
    
    QToolButton* m_pSearchToolButton;
    QToolButton* m_pShowAllToolButton;
   
    QToolButton* m_pImportToolButton;
    QToolButton* m_pExportToolButton;
    
    ZeeRecipeListView* m_pRecipeListView;
    QLabel* m_pStatusLabel;
};

#endif // ZEEMAINWINDOW_H
