#include "zeeingredientlistview.h"

#include "sql/qsqlquery.h"

ZeeIngredientListViewItem::ZeeIngredientListViewItem(int recipeIngredientId, QString key, QString quantity, QString unit, QString name, bool isGroup, QListView* parent)
    : QListViewItem(parent)
{
    m_recipeIngredientId = recipeIngredientId;
    m_key = key;
    m_isGroup = isGroup;

    setText(0, quantity);
    setText(1, unit);
    setText(2, name);
}

ZeeIngredientListViewItem::~ZeeIngredientListViewItem()
{
}

int ZeeIngredientListViewItem::recipeIngredientId() const
{
    return m_recipeIngredientId;
}

QString ZeeIngredientListViewItem::key(int, bool) const
{
    return m_key;
}

void ZeeIngredientListViewItem::paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align)
{
    if (m_isGroup) {
        QFont oldFont = p->font();
        QFont newFont = oldFont;
        newFont.setBold(true);

        p->setFont(newFont);
        QListViewItem::paintCell(p, cg, column, width, align);
        p->setFont(oldFont);
    } else {
        QListViewItem::paintCell(p, cg, column, width, align);
    }
}

ZeeIngredientListView::ZeeIngredientListView(int recipeId, QWidget* parent, const char* name)
    : ZeeListView(parent, name)
{
    m_recipeId = recipeId;

    setAllColumnsShowFocus(true);

    addColumn(tr("Qty"));
    addColumn(tr("Unit"));
    addColumn(tr("Ingredient"));

    updateView();
}

ZeeIngredientListView::~ZeeIngredientListView()
{
}

void ZeeIngredientListView::updateView()
{
    blockSignals(true);

    int selectedId = selected();

    clear();

    QString queryString = "SELECT recipe_ingredient.id, position, quantity, unit.name, ingredient.name, is_group";
    queryString += " FROM recipe_ingredient LEFT JOIN unit ON unit_id = unit.id, ingredient";
    queryString += " WHERE recipe_id = %1 AND ingredient_id = ingredient.id";

    QSqlQuery query(queryString.arg(m_recipeId));

    while (query.next()) {
        int id = query.value(0).toInt();
        int position = query.value(1).toInt();
        QString quantity = query.value(2).toString();
        QString unit = query.value(3).toString();
        QString name = query.value(4).toString();
        bool isGroup = query.value(5).toInt();

        new ZeeIngredientListViewItem(id, QString().sprintf("%010d", position), quantity, unit, name, isGroup, this);
    }

    if (selectedId != -1) {
        select(selectedId);
    }

    blockSignals(false);
}

void ZeeIngredientListView::select(int recipeIngredientId)
{
    ZeeIngredientListViewItem* item = (ZeeIngredientListViewItem*)firstChild();

    while (item) {
        if (item->recipeIngredientId() == recipeIngredientId) {
            setSelected(item, true);
            ensureItemVisible(item);
            break;
        }

        item = (ZeeIngredientListViewItem*)(item->nextSibling());
    }
}

int ZeeIngredientListView::selected() const
{
    int recipeIngredientId;

    ZeeIngredientListViewItem* item = (ZeeIngredientListViewItem*)selectedItem();

    if (item) {
        recipeIngredientId = item->recipeIngredientId();
    } else {
        recipeIngredientId = -1;
    }

    return recipeIngredientId;
}
