#ifndef ZEEIMPORTER_H
#define ZEEIMPORTER_H

#include <qobject.h>

#include <qtextstream.h>

class ZeeImporter : public QObject
{
    Q_OBJECT

protected:
    ZeeImporter();

public:
    virtual ~ZeeImporter();

    virtual QString name() const = 0;
    virtual QString mimeType() const = 0;
    virtual int totalSteps(QTextStream& textStream) const = 0;

    virtual void importRecipeList(QTextStream& textStream) = 0;
    
signals:
    void progressed(int progress);
    
protected:
    int progress;
};

#endif // ZEEIMPORTER_H
