#ifndef ZEEDOCLISTVIEW_H
#define ZEEDOCLISTVIEW_H

#include "zeelistview.h"

class DocLnk;
class DocLnkSet;

class ZeeDocListViewItem : public QListViewItem
{
public:
    ZeeDocListViewItem(DocLnk* docLnk, QListView* parent);
    ~ZeeDocListViewItem();

    DocLnk* docLnk() const;

    QString key(int column, bool ascending) const;

private:
    DocLnk* m_pDocLnk;
};

class ZeeDocListView : public ZeeListView
{
public:
    ZeeDocListView(QString filter = QString::null, QWidget* parent = 0, const char* name = 0);
    ~ZeeDocListView();

    void updateView();

    void select(DocLnk* docLnk);
    DocLnk* selected() const;
    
private:
    QString m_filter;
    DocLnkSet* m_pDocLnkSet;
};

#endif // ZEEDOCLISTVIEW_H
