#ifndef ZEEDOCLISTVIEW_H
#define ZEEDOCLISTVIEW_H

#include "zeelistview.h"

class DocLnk;
class DocLnkSet;

class ZeeCookbookListViewItem : public QListViewItem
{
public:
    ZeeCookbookListViewItem(DocLnk* docLnk, QListView* parent);
    ~ZeeCookbookListViewItem();

    DocLnk* docLnk() const;

    QString key(int column, bool ascending) const;

private:
    DocLnk* m_pDocLnk;
};

class ZeeCookbookListView : public ZeeListView
{
public:
    ZeeCookbookListView(QString filter = QString::null, QWidget* parent = 0, const char* name = 0);
    ~ZeeCookbookListView();

    void updateView();

    void select(DocLnk* docLnk);
    DocLnk* selected() const;
    
private:
    QString m_filter;
    DocLnkSet* m_pDocLnkSet;
};

#endif // ZEEDOCLISTVIEW_H
