/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    int boxHandle;
    int labelHandle;
    int imageHandle;
    int arrowHandle;
    int groupHandle;
    boolean selected;
    boolean grayed;
    ImageList imageList;
    Image image;
    String text;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        this.forceResize();
        int[] nArray = null;
        int[] nArray2 = null;
        if ((this.style & 0x30) != 0) {
            nArray = new int[1];
            nArray2 = new int[1];
            OS.gtk_widget_get_size_request(this.boxHandle, nArray, nArray2);
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, nArray[0], nArray2[0]);
        }
        if ((n != -1 || n2 != -1) && (OS.GTK_WIDGET_FLAGS(this.handle) & 0x2000) != 0) {
            int[] nArray3 = new int[1];
            GtkBorder gtkBorder = new GtkBorder();
            OS.gtk_widget_style_get(this.handle, OS.default_border, nArray3, 0);
            if (nArray3[0] != 0) {
                OS.memmove(gtkBorder, nArray3[0], GtkBorder.sizeof);
            } else {
                gtkBorder.bottom = 1;
                gtkBorder.top = 1;
                gtkBorder.right = 1;
                gtkBorder.left = 1;
            }
            if (n != -1) {
                point.x += gtkBorder.left + gtkBorder.right;
            }
            if (n2 != -1) {
                point.y += gtkBorder.top + gtkBorder.bottom;
            }
        }
        return point;
    }

    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 8) == 0) {
            this.state |= 0x10000;
        }
        int n2 = 62;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        switch (this.style & n2) {
            case 4: {
                int n3 = 0;
                if ((this.style & 0x80) != 0) {
                    n3 = 0;
                }
                if ((this.style & 0x400) != 0) {
                    n3 = 1;
                }
                if ((this.style & 0x4000) != 0) {
                    n3 = 2;
                }
                if ((this.style & 0x20000) != 0) {
                    n3 = 3;
                }
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(n3, 2);
                if (this.arrowHandle != 0) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_button_new(0);
                if (this.groupHandle == 0) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.gtk_object_sink(this.groupHandle);
                this.handle = OS.gtk_radio_button_new(OS.gtk_radio_button_get_group(this.groupHandle));
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.GTK_WIDGET_SET_FLAGS(this.handle, 8192);
            }
        }
        if ((this.style & 4) != 0) {
            OS.gtk_container_add(this.handle, this.arrowHandle);
        } else {
            this.boxHandle = OS.gtk_hbox_new(false, 4);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.boxHandle);
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        this._setAlignment(this.style & 0x1024000);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    void deregister() {
        super.deregister();
        if (this.boxHandle != 0) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    int fontHandle() {
        if (this.labelHandle != 0) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return n3;
    }

    int gtk_clicked(int n) {
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            if (OS.gtk_toggle_button_get_active(this.handle)) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        this.postEvent(13);
        return 0;
    }

    int gtk_focus_in_event(int n, int n2) {
        int n3 = super.gtk_focus_in_event(n, n2);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && OS.GTK_WIDGET_HAS_DEFAULT(this.handle)) {
            Decorations decorations = this.menuShell();
            decorations.defaultButton = this;
        }
        return n3;
    }

    int gtk_focus_out_event(int n, int n2) {
        int n3 = super.gtk_focus_out_event(n, n2);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && !OS.GTK_WIDGET_HAS_DEFAULT(this.handle)) {
            Decorations decorations = this.menuShell();
            if (decorations.defaultButton == this) {
                decorations.defaultButton = null;
            }
        }
        return n3;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return n3;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    boolean isDescribedByLabel() {
        return false;
    }

    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    void register() {
        super.register();
        if (this.boxHandle != 0) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0;
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.boxHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeHandle(int n, int n2) {
        super.resizeHandle(n, n2);
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, n, -1);
        }
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (this != control) {
                control.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this._setAlignment(n);
    }

    void _setAlignment(int n) {
        boolean bl;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            int n2 = 0;
            boolean bl2 = (this.style & 0x4000000) != 0;
            switch (n) {
                case 128: {
                    n2 = 0;
                    break;
                }
                case 1024: {
                    n2 = 1;
                    break;
                }
                case 16384: {
                    n2 = bl2 ? 3 : 2;
                    break;
                }
                case 131072: {
                    n2 = bl2 ? 2 : 3;
                }
            }
            OS.gtk_arrow_set(this.arrowHandle, n2, 2);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        boolean bl3 = bl = OS.GTK_WIDGET_VISIBLE(this.labelHandle) && OS.GTK_WIDGET_VISIBLE(this.imageHandle);
        if (bl) {
            if ((this.style & 0x30) != 0) {
                n = 16384;
            }
            if ((this.style & 0xA) != 0) {
                n = 0x1000000;
            }
        }
        if ((n & 0x4000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 0);
            OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            return;
        }
        if ((n & 0x1000000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.5f);
                OS.gtk_label_set_justify(this.labelHandle, 2);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            }
            return;
        }
        if ((n & 0x20000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            }
            OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.5f);
            OS.gtk_label_set_justify(this.labelHandle, 1);
            OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            return;
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        this.setBackgroundColor(this.fixedHandle, gdkColor);
        if (this.labelHandle != 0) {
            this.setBackgroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundColor(this.imageHandle, gdkColor);
        }
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        if (this.labelHandle != 0) {
            OS.gtk_widget_modify_font(this.labelHandle, n);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_modify_font(this.imageHandle, n);
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        this.setForegroundColor(this.fixedHandle, gdkColor);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, gdkColor);
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
        if (bl && OS.gtk_toggle_button_get_active(this.handle)) {
            OS.gtk_toggle_button_set_inconsistent(this.handle, true);
        } else {
            OS.gtk_toggle_button_set_inconsistent(this.handle, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int n = this.imageList.add(image);
            int n2 = this.imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.image = image;
        this._setAlignment(this.style);
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.boxHandle != 0) {
                OS.gtk_widget_set_direction(this.boxHandle, 2);
            }
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, 2);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, 2);
            }
            if (this.arrowHandle != 0) {
                switch (this.style & 0x24000) {
                    case 16384: {
                        OS.gtk_arrow_set(this.arrowHandle, 3, 2);
                        break;
                    }
                    case 131072: {
                        OS.gtk_arrow_set(this.arrowHandle, 2, 2);
                    }
                }
            }
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 8);
        OS.gtk_toggle_button_set_active(this.handle, bl);
        if ((this.style & 0x20) != 0) {
            if (bl && this.grayed) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_toggle_button_set_active(this.groupHandle, !bl);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 8);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (this.image == null) {
            OS.gtk_widget_hide(this.imageHandle);
        }
        OS.gtk_widget_show(this.labelHandle);
        this._setAlignment(this.style);
    }

    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0) {
            OS.gtk_widget_show(this.arrowHandle);
        }
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = super.traversalCode(n, gdkEventKey);
        if ((this.style & 4) != 0) {
            n2 &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            n2 |= 0x60;
        }
        return n2;
    }
}

