/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    String shortenedText;
    int shortenedTextWidth;
    Font font;
    Image disabledImage;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 0;
    boolean showClose = false;
    boolean showing = false;
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";

    public CTabItem(CTabFolder parent, int style) {
        this(parent, style, parent.getItemCount());
    }

    public CTabItem(CTabFolder parent, int style, int index) {
        super(parent, style);
        this.showClose = (style & 0x40) != 0;
        parent.createItem(this, index);
    }

    boolean useEllipses() {
        return this.parent.simple;
    }

    String shortenText(GC gc, String text, int width) {
        return this.useEllipses() ? this.shortenText(gc, text, width, ELLIPSIS) : this.shortenText(gc, text, width, "");
    }

    String shortenText(GC gc, String text, int width, String ellipses) {
        if (gc.textExtent((String)text, (int)9).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipses, (int)9).x;
        int length = text.length();
        TextLayout layout = new TextLayout(this.getDisplay());
        layout.setText(text);
        int end = layout.getPreviousOffset(length, 2);
        while (end > 0) {
            text = text.substring(0, end);
            int l = gc.textExtent((String)text, (int)9).x;
            if (l + ellipseWidth <= width) break;
            end = layout.getPreviousOffset(end, 2);
        }
        layout.dispose();
        return end == 0 ? text.substring(0, 1) : String.valueOf(text) + ellipses;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
        this.font = null;
    }

    void drawClose(GC gc) {
        if (this.closeRect.width == 0 || this.closeRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int indent = Math.max(1, 4);
        int x = this.closeRect.x + indent;
        int y = this.closeRect.y + indent;
        y += this.parent.onBottom ? -1 : 1;
        Color closeBorder = display.getSystemColor(17);
        switch (this.closeImageState) {
            case 1: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                gc.setBackground(display.getSystemColor(25));
                gc.fillPolygon(shape);
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 2: {
                int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
                Color fill = new Color(display, CTabFolder.CLOSE_FILL);
                gc.setBackground(fill);
                gc.fillPolygon(shape);
                fill.dispose();
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 3: {
                int[] shape = new int[]{x + 1, y + 1, x + 3, y + 1, x + 5, y + 3, x + 6, y + 3, x + 8, y + 1, x + 10, y + 1, x + 10, y + 3, x + 8, y + 5, x + 8, y + 6, x + 10, y + 8, x + 10, y + 10, x + 8, y + 10, x + 6, y + 8, x + 5, y + 8, x + 3, y + 10, x + 1, y + 10, x + 1, y + 8, x + 3, y + 6, x + 3, y + 5, x + 1, y + 3};
                Color fill = new Color(display, CTabFolder.CLOSE_FILL);
                gc.setBackground(fill);
                gc.fillPolygon(shape);
                fill.dispose();
                gc.setForeground(closeBorder);
                gc.drawPolygon(shape);
                break;
            }
            case 0: {
                int[] shape = new int[]{x, y, x + 10, y, x + 10, y + 10, x, y + 10};
                if (this.parent.gradientColors != null && !this.parent.gradientVertical) {
                    this.parent.drawBackground(gc, shape, false);
                    break;
                }
                Color defaultBackground = this.parent.getBackground();
                Image image = this.parent.bgImage;
                Color[] colors = this.parent.gradientColors;
                int[] percents = this.parent.gradientPercents;
                boolean vertical = this.parent.gradientVertical;
                this.parent.drawBackground(gc, shape, x, y, 10, 10, defaultBackground, image, colors, percents, vertical);
            }
        }
    }

    void drawSelected(GC gc) {
        Image image;
        Point size = this.parent.getSize();
        int rightEdge = Math.min(this.x + this.width, this.parent.getRightItemEdge());
        int xx = this.parent.borderLeft;
        int yy = this.parent.onBottom ? size.y - this.parent.borderBottom - this.parent.tabHeight - this.parent.highlight_header : this.parent.borderTop + this.parent.tabHeight + 1;
        int ww = size.x - this.parent.borderLeft - this.parent.borderRight;
        int hh = this.parent.highlight_header - 1;
        int[] shape = new int[]{xx, yy, xx + ww, yy, xx + ww, yy + hh, xx, yy + hh};
        if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
            this.parent.drawBackground(gc, shape, true);
        } else {
            gc.setBackground(this.parent.selectionBackground);
            gc.fillRectangle(xx, yy, ww, hh);
        }
        if (this.parent.single) {
            if (!this.showing) {
                return;
            }
        } else {
            boolean tabInPaint;
            int i;
            int index;
            int[] right;
            int[] left;
            if (!this.showing) {
                int x1 = Math.max(0, this.parent.borderLeft - 1);
                int y1 = this.parent.onBottom ? this.y - 1 : this.y + this.height;
                int x2 = size.x - this.parent.borderRight;
                gc.setForeground(CTabFolder.borderColor);
                gc.drawLine(x1, y1, x2, y1);
                return;
            }
            shape = null;
            if (this.parent.onBottom) {
                left = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_LEFT_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
                int[] nArray = right = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    left = new int[]{this.x, this.y + this.height};
                }
                shape = new int[left.length + right.length + 8];
                index = 0;
                shape[index++] = this.x;
                shape[index++] = this.y - 1;
                shape[index++] = this.x;
                shape[index++] = this.y - 1;
                i = 0;
                while (i < left.length / 2) {
                    shape[index++] = this.x + left[2 * i];
                    shape[index++] = this.y + this.height + left[2 * i + 1] - 1;
                    ++i;
                }
                i = 0;
                while (i < right.length / 2) {
                    shape[index++] = this.parent.simple ? rightEdge - 1 + right[2 * i] : rightEdge - this.parent.curveIndent + right[2 * i];
                    shape[index++] = this.parent.simple ? this.y + this.height + right[2 * i + 1] - 1 : this.y + right[2 * i + 1] - 2;
                    ++i;
                }
                shape[index++] = this.parent.simple ? rightEdge - 1 : rightEdge + this.parent.curveWidth - this.parent.curveIndent;
                shape[index++] = this.y - 1;
                shape[index++] = this.parent.simple ? rightEdge - 1 : rightEdge + this.parent.curveWidth - this.parent.curveIndent;
                shape[index++] = this.y - 1;
            } else {
                left = this.parent.simple ? CTabFolder.SIMPLE_TOP_LEFT_CORNER : CTabFolder.TOP_LEFT_CORNER;
                int[] nArray = right = this.parent.simple ? CTabFolder.SIMPLE_TOP_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    left = new int[]{this.x, this.y};
                }
                shape = new int[left.length + right.length + 8];
                index = 0;
                shape[index++] = this.x;
                shape[index++] = this.y + this.height + 1;
                shape[index++] = this.x;
                shape[index++] = this.y + this.height + 1;
                i = 0;
                while (i < left.length / 2) {
                    shape[index++] = this.x + left[2 * i];
                    shape[index++] = this.y + left[2 * i + 1];
                    ++i;
                }
                i = 0;
                while (i < right.length / 2) {
                    shape[index++] = this.parent.simple ? rightEdge - 1 + right[2 * i] : rightEdge - this.parent.curveIndent + right[2 * i];
                    shape[index++] = this.y + right[2 * i + 1];
                    ++i;
                }
                shape[index++] = this.parent.simple ? rightEdge - 1 : rightEdge + this.parent.curveWidth - this.parent.curveIndent;
                shape[index++] = this.y + this.height + 1;
                shape[index++] = this.parent.simple ? rightEdge - 1 : rightEdge + this.parent.curveWidth - this.parent.curveIndent;
                shape[index++] = this.y + this.height + 1;
            }
            Rectangle clipping = gc.getClipping();
            Rectangle bounds = this.getBounds();
            ++bounds.height;
            if (this.parent.onBottom) {
                --bounds.y;
            }
            if (tabInPaint = clipping.intersects(bounds)) {
                if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                    this.parent.drawBackground(gc, shape, true);
                } else {
                    Color defaultBackground = this.parent.selectionBackground;
                    Image image2 = this.parent.selectionBgImage;
                    Color[] colors = this.parent.selectionGradientColors;
                    int[] percents = this.parent.selectionGradientPercents;
                    boolean vertical = this.parent.selectionGradientVertical;
                    xx = this.x;
                    yy = this.parent.onBottom ? this.y - 1 : this.y + 1;
                    ww = this.width;
                    hh = this.height;
                    if (!this.parent.single && !this.parent.simple) {
                        ww += this.parent.curveWidth - this.parent.curveIndent;
                    }
                    this.parent.drawBackground(gc, shape, xx, yy, ww, hh, defaultBackground, image2, colors, percents, vertical);
                }
            }
            this.drawHighlight(gc, rightEdge);
            shape[0] = Math.max(0, this.parent.borderLeft - 1);
            if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                shape[1] = this.parent.onBottom ? this.y + this.height - 1 : this.y;
                shape[5] = shape[3] = shape[1];
            }
            shape[shape.length - 2] = size.x - this.parent.borderRight + 1;
            int i2 = 0;
            while (i2 < shape.length / 2) {
                if (shape[2 * i2 + 1] == this.y + this.height + 1) {
                    int n = 2 * i2 + 1;
                    shape[n] = shape[n] - 1;
                }
                ++i2;
            }
            RGB inside = this.parent.selectionBackground.getRGB();
            if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
                inside = null;
            }
            RGB outside = this.parent.getBackground().getRGB();
            if (this.parent.bgImage != null || this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
                outside = null;
            }
            this.parent.antialias(shape, CTabFolder.borderColor.getRGB(), inside, outside, gc);
            gc.setForeground(CTabFolder.borderColor);
            gc.drawPolyline(shape);
            if (!tabInPaint) {
                return;
            }
        }
        int xDraw = this.x + 4;
        if (this.parent.single && (this.parent.showClose || this.showClose)) {
            xDraw += 18;
        }
        if ((image = this.getImage()) != null) {
            Rectangle imageBounds = image.getBounds();
            int maxImageWidth = rightEdge - xDraw - 4;
            if (!this.parent.single && this.closeRect.width > 0) {
                maxImageWidth -= this.closeRect.width + 4;
            }
            if (imageBounds.width < maxImageWidth) {
                int imageX = xDraw;
                int imageY = this.y + (this.height - imageBounds.height) / 2;
                gc.drawImage(image, imageX, imageY += this.parent.onBottom ? -1 : 1);
                xDraw += imageBounds.width + 4;
            }
        }
        int textWidth = rightEdge - xDraw - 4;
        if (!this.parent.single && this.closeRect.width > 0) {
            textWidth -= this.closeRect.width + 4;
        }
        if (textWidth > 0) {
            Font gcFont = gc.getFont();
            gc.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
                this.shortenedText = this.shortenText(gc, this.getText(), textWidth);
                this.shortenedTextWidth = textWidth;
            }
            Point extent = gc.textExtent(this.shortenedText, 9);
            int textY = this.y + (this.height - extent.y) / 2;
            int n = this.parent.onBottom ? -1 : 1;
            gc.setForeground(this.parent.selectionForeground);
            gc.drawText(this.shortenedText, xDraw, textY += n, 9);
            gc.setFont(gcFont);
            if (this.parent.isFocusControl()) {
                Display display = this.getDisplay();
                if (this.parent.simple || this.parent.single) {
                    gc.setBackground(display.getSystemColor(2));
                    gc.setForeground(display.getSystemColor(1));
                    gc.drawFocus(xDraw - 1, textY - 1, extent.x + 2, extent.y + 2);
                } else {
                    gc.setForeground(display.getSystemColor(17));
                    gc.drawLine(xDraw, textY + extent.y + 1, xDraw + extent.x + 1, textY + extent.y + 1);
                }
            }
        }
        if (this.parent.showClose || this.showClose) {
            this.drawClose(gc);
        }
    }

    void drawHighlight(GC gc, int rightEdge) {
        int rawY;
        int rawX;
        if (this.parent.simple || this.parent.onBottom) {
            return;
        }
        if (this.parent.selectionHighlightGradientBegin == null) {
            return;
        }
        Color[] gradients = this.parent.selectionHighlightGradientColorsCache;
        if (gradients == null) {
            return;
        }
        int gradientsSize = gradients.length;
        if (gradientsSize == 0) {
            return;
        }
        gc.setForeground(gradients[0]);
        gc.drawLine(CTabFolder.TOP_LEFT_CORNER_HILITE[0] + this.x + 1, 1 + this.y, rightEdge - this.parent.curveIndent, 1 + this.y);
        int[] leftHighlightCurve = CTabFolder.TOP_LEFT_CORNER_HILITE;
        int d = this.parent.tabHeight - this.parent.topCurveHighlightEnd.length / 2;
        int lastX = 0;
        int lastY = 0;
        int lastColorIndex = 0;
        int i = 0;
        while (i < leftHighlightCurve.length / 2) {
            int rawX2 = leftHighlightCurve[i * 2];
            int rawY2 = leftHighlightCurve[i * 2 + 1];
            lastX = rawX2 + this.x;
            lastY = rawY2 + this.y;
            lastColorIndex = rawY2 - 1;
            gc.setForeground(gradients[lastColorIndex]);
            gc.drawPoint(lastX, lastY);
            ++i;
        }
        i = lastColorIndex;
        while (i < gradientsSize) {
            gc.setForeground(gradients[i]);
            gc.drawPoint(lastX, 1 + lastY++);
            ++i;
        }
        int rightEdgeOffset = rightEdge - this.parent.curveIndent;
        int i2 = 0;
        while (i2 < this.parent.topCurveHighlightStart.length / 2) {
            rawX = this.parent.topCurveHighlightStart[i2 * 2];
            rawY = this.parent.topCurveHighlightStart[i2 * 2 + 1];
            lastX = rawX + rightEdgeOffset;
            lastY = rawY + this.y;
            lastColorIndex = rawY - 1;
            if (lastColorIndex >= gradientsSize) break;
            gc.setForeground(gradients[lastColorIndex]);
            gc.drawPoint(lastX, lastY);
            ++i2;
        }
        i2 = lastColorIndex;
        while (i2 < lastColorIndex + d) {
            if (i2 >= gradientsSize) break;
            gc.setForeground(gradients[i2]);
            gc.drawPoint(1 + lastX++, 1 + lastY++);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.parent.topCurveHighlightEnd.length / 2) {
            rawX = this.parent.topCurveHighlightEnd[i2 * 2];
            rawY = this.parent.topCurveHighlightEnd[i2 * 2 + 1];
            lastX = rawX + rightEdgeOffset;
            lastY = rawY + this.y;
            lastColorIndex = rawY - 1;
            if (lastColorIndex >= gradientsSize) break;
            gc.setForeground(gradients[lastColorIndex]);
            gc.drawPoint(lastX, lastY);
            ++i2;
        }
    }

    void drawRightUnselectedBorder(GC gc) {
        int[] shape = null;
        int startX = this.x + this.width - 1;
        if (this.parent.onBottom) {
            int[] right = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_RIGHT_CORNER;
            shape = new int[right.length + 2];
            int index = 0;
            int i = 0;
            while (i < right.length / 2) {
                shape[index++] = startX + right[2 * i];
                shape[index++] = this.y + this.height + right[2 * i + 1] - 1;
                ++i;
            }
            shape[index++] = startX;
            shape[index++] = this.y - 1;
        } else {
            int[] right = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_RIGHT_CORNER;
            shape = new int[right.length + 2];
            int index = 0;
            int i = 0;
            while (i < right.length / 2) {
                shape[index++] = startX + right[2 * i];
                shape[index++] = this.y + right[2 * i + 1];
                ++i;
            }
            shape[index++] = startX;
            shape[index++] = this.y + this.height;
        }
        this.drawBorder(gc, shape);
    }

    void drawBorder(GC gc, int[] shape) {
        gc.setForeground(CTabFolder.borderColor);
        gc.drawPolyline(shape);
    }

    void drawLeftUnselectedBorder(GC gc) {
        int[] shape = null;
        if (this.parent.onBottom) {
            int[] left = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
            shape = new int[left.length + 2];
            int index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y - 1;
            int i = 0;
            while (i < left.length / 2) {
                shape[index++] = this.x + left[2 * i];
                shape[index++] = this.y + this.height + left[2 * i + 1] - 1;
                ++i;
            }
        } else {
            int[] left = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_LEFT_CORNER;
            shape = new int[left.length + 2];
            int index = 0;
            shape[index++] = this.x;
            shape[index++] = this.y + this.height;
            int i = 0;
            while (i < left.length / 2) {
                shape[index++] = this.x + left[2 * i];
                shape[index++] = this.y + left[2 * i + 1];
                ++i;
            }
        }
        this.drawBorder(gc, shape);
    }

    void drawUnselected(GC gc) {
        Rectangle bounds;
        if (!this.showing) {
            return;
        }
        Rectangle clipping = gc.getClipping();
        if (!clipping.intersects(bounds = this.getBounds())) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index > 0 && index < this.parent.selectedIndex) {
            this.drawLeftUnselectedBorder(gc);
        }
        if (index > this.parent.selectedIndex) {
            this.drawRightUnselectedBorder(gc);
        }
        int xDraw = this.x + 4;
        Image image = this.getImage();
        if (image != null && this.parent.showUnselectedImage) {
            Rectangle imageBounds = image.getBounds();
            int maxImageWidth = this.x + this.width - xDraw - 4;
            if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                maxImageWidth -= this.closeRect.width + 4;
            }
            if (imageBounds.width < maxImageWidth) {
                int imageX = xDraw;
                int imageHeight = imageBounds.height;
                int imageY = this.y + (this.height - imageHeight) / 2;
                int n = this.parent.onBottom ? -1 : 1;
                int imageWidth = imageBounds.width * imageHeight / imageBounds.height;
                gc.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, imageX, imageY += n, imageWidth, imageHeight);
                xDraw += imageWidth + 4;
            }
        }
        int textWidth = this.x + this.width - xDraw - 4;
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            textWidth -= this.closeRect.width + 4;
        }
        if (textWidth > 0) {
            Font gcFont = gc.getFont();
            gc.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != textWidth) {
                this.shortenedText = this.shortenText(gc, this.getText(), textWidth);
                this.shortenedTextWidth = textWidth;
            }
            Point extent = gc.textExtent(this.shortenedText, 9);
            int textY = this.y + (this.height - extent.y) / 2;
            int n = this.parent.onBottom ? -1 : 1;
            gc.setForeground(this.parent.getForeground());
            gc.drawText(this.shortenedText, xDraw, textY += n, 9);
            gc.setFont(gcFont);
        }
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            this.drawClose(gc);
        }
    }

    public Rectangle getBounds() {
        int w = this.width;
        if (!this.parent.simple && !this.parent.single && this.parent.indexOf(this) == this.parent.selectedIndex) {
            w += this.parent.curveWidth - this.parent.curveIndent;
        }
        return new Rectangle(this.x, this.y, w, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public String getToolTipText() {
        String text;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(text = this.getText())) {
            return text;
        }
        return this.toolTipText;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    void onPaint(GC gc, boolean isSelected) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (isSelected) {
            this.drawSelected(gc);
        } else {
            this.drawUnselected(gc);
        }
    }

    int preferredHeight(GC gc) {
        Image image = this.getImage();
        int h = image == null ? 0 : image.getBounds().height;
        String text = this.getText();
        if (this.font == null) {
            h = Math.max(h, gc.textExtent((String)text, (int)9).y);
        } else {
            Font gcFont = gc.getFont();
            gc.setFont(this.font);
            h = Math.max(h, gc.textExtent((String)text, (int)9).y);
            gc.setFont(gcFont);
        }
        return h + 2 + 2;
    }

    int preferredWidth(GC gc, boolean isSelected, boolean minimum) {
        if (this.isDisposed()) {
            return 0;
        }
        int w = 0;
        Image image = this.getImage();
        if (image != null && (isSelected || this.parent.showUnselectedImage)) {
            w += image.getBounds().width;
        }
        String text = null;
        if (minimum) {
            int minChars = this.parent.minChars;
            String string = text = minChars == 0 ? null : this.getText();
            if (text != null && text.length() > minChars) {
                if (this.useEllipses()) {
                    int end = minChars < ELLIPSIS.length() + 1 ? minChars : minChars - ELLIPSIS.length();
                    text = text.substring(0, end);
                    if (minChars > ELLIPSIS.length() + 1) {
                        text = String.valueOf(text) + ELLIPSIS;
                    }
                } else {
                    int end = minChars;
                    text = text.substring(0, end);
                }
            }
        } else {
            text = this.getText();
        }
        if (text != null) {
            if (w > 0) {
                w += 4;
            }
            if (this.font == null) {
                w += gc.textExtent((String)text, (int)9).x;
            } else {
                Font gcFont = gc.getFont();
                gc.setFont(this.font);
                w += gc.textExtent((String)text, (int)9).x;
                gc.setFont(gcFont);
            }
        }
        if ((this.parent.showClose || this.showClose) && (isSelected || this.parent.showUnselectedClose)) {
            if (w > 0) {
                w += 4;
            }
            w += 18;
        }
        return w + 4 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int index = this.parent.indexOf(this);
            if (index == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.disabledImage = image;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font == null && this.font == null) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        Image oldImage = this.getImage();
        if (image == null && oldImage == null) {
            return;
        }
        if (image != null && image.equals(oldImage)) {
            return;
        }
        super.setImage(image);
        if (!this.parent.updateTabHeight(false)) {
            if (oldImage != null && image != null) {
                Rectangle oldBounds = oldImage.getBounds();
                Rectangle bounds = image.getBounds();
                if (bounds.width == oldBounds.width && bounds.height == oldBounds.height) {
                    if (this.showing) {
                        boolean selected;
                        boolean bl = selected = this.parent.indexOf(this) == this.parent.selectedIndex;
                        if (selected || this.parent.showUnselectedImage) {
                            int maxImageWidth;
                            int imageX = this.x + 4;
                            if (selected) {
                                if (this.parent.single && (this.parent.showClose || this.showClose)) {
                                    imageX += 18;
                                }
                                int rightEdge = Math.min(this.x + this.width, this.parent.getRightItemEdge());
                                maxImageWidth = rightEdge - imageX - 4;
                                if (!this.parent.single && this.closeRect.width > 0) {
                                    maxImageWidth -= this.closeRect.width + 4;
                                }
                            } else {
                                maxImageWidth = this.x + this.width - imageX - 4;
                                if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                                    maxImageWidth -= this.closeRect.width + 4;
                                }
                            }
                            if (bounds.width < maxImageWidth) {
                                int imageY = this.y + (this.height - bounds.height) / 2 + (this.parent.onBottom ? -1 : 1);
                                this.parent.redraw(imageX, imageY, bounds.width, bounds.height, false);
                            }
                        }
                    }
                    return;
                }
            }
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

