/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    int surface;
    int surfaceData;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n, n2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image image, int n) {
        int n2;
        int n3;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.device = device;
        this.type = image.type;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
        int n4 = nArray[0];
        int n5 = nArray2[0];
        if (image.type == 1 && image.mask != 0 || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                image.createMask();
            }
            if ((n3 = OS.gdk_pixmap_new(0, n4, n5, 1)) == 0) {
                SWT.error(2);
            }
            if ((n2 = OS.gdk_gc_new(n3)) == 0) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(n3, n2, image.mask, 0, 0, 0, 0, n4, n5);
            OS.g_object_unref(n2);
            this.mask = n3;
            if (image.transparentPixel != -1 && image.memGC != null) {
                image.destroyMask();
            }
        }
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        this.alpha = image.alpha;
        if (image.alphaData != null) {
            this.alphaData = new byte[image.alphaData.length];
            System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        this.createAlphaMask(n4, n5);
        n3 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n4, n5, -1);
        if (n3 == 0) {
            SWT.error(2);
        }
        if ((n2 = OS.gdk_gc_new(n3)) == 0) {
            SWT.error(2);
        }
        this.pixmap = n3;
        if (n == 0) {
            OS.gdk_draw_drawable(n3, n2, image.pixmap, 0, 0, 0, 0, n4, n5);
            OS.g_object_unref(n2);
            if (device.tracking) {
                device.new_Object(this);
            }
            return;
        }
        int n6 = OS.gdk_pixbuf_new(0, false, 8, n4, n5);
        if (n6 == 0) {
            SWT.error(2);
        }
        int n7 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n6, image.pixmap, n7, 0, 0, 0, 0, n4, n5);
        int n8 = OS.gdk_pixbuf_get_rowstride(n6);
        int n9 = OS.gdk_pixbuf_get_pixels(n6);
        switch (n) {
            case 1: {
                Color color = device.getSystemColor(18);
                RGB rGB = color.getRGB();
                byte by = (byte)rGB.red;
                byte by2 = (byte)rGB.green;
                byte by3 = (byte)rGB.blue;
                Color color2 = device.getSystemColor(22);
                RGB rGB2 = color2.getRGB();
                byte by4 = (byte)rGB2.red;
                byte by5 = (byte)rGB2.green;
                byte by6 = (byte)rGB2.blue;
                byte[] byArray = new byte[n8];
                int n10 = 0;
                while (n10 < n5) {
                    OS.memmove(byArray, n9 + n10 * n8, n8);
                    int n11 = 0;
                    while (n11 < n4) {
                        int n12 = n11 * 3;
                        int n13 = byArray[n12] & 0xFF;
                        int n14 = byArray[n12 + 1] & 0xFF;
                        int n15 = byArray[n12 + 2] & 0xFF;
                        int n16 = n13 * n13 + n14 * n14 + n15 * n15;
                        if (n16 < 98304) {
                            byArray[n12] = by;
                            byArray[n12 + 1] = by2;
                            byArray[n12 + 2] = by3;
                        } else {
                            byArray[n12] = by4;
                            byArray[n12 + 1] = by5;
                            byArray[n12 + 2] = by6;
                        }
                        ++n11;
                    }
                    OS.memmove(n9 + n10 * n8, byArray, n8);
                    ++n10;
                }
                break;
            }
            case 2: {
                byte[] byArray = new byte[n8];
                int n17 = 0;
                while (n17 < n5) {
                    OS.memmove(byArray, n9 + n17 * n8, n8);
                    int n18 = 0;
                    while (n18 < n4) {
                        byte by;
                        int n19 = n18 * 3;
                        int n20 = byArray[n19] & 0xFF;
                        int n21 = byArray[n19 + 1] & 0xFF;
                        int n22 = byArray[n19 + 2] & 0xFF;
                        byte by7 = by = (byte)(n20 + n20 + n21 + n21 + n21 + n21 + n21 + n22 >> 3);
                        byArray[n19 + 2] = by7;
                        byArray[n19 + 1] = by7;
                        byArray[n19] = by7;
                        ++n18;
                    }
                    OS.memmove(n9 + n17 * n8, byArray, n8);
                    ++n17;
                }
                break;
            }
        }
        OS.gdk_pixbuf_render_to_drawable(n6, n3, n2, 0, 0, 0, 0, n4, n5, 1, 0, 0);
        OS.g_object_unref(n6);
        OS.g_object_unref(n2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Rectangle rectangle) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(device, rectangle.width, rectangle.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, imageData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(device, imageData3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream inputStream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(inputStream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String string) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.device = device;
        try {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
            int n2 = OS.gdk_pixbuf_new_from_file(byArray, null);
            if (n2 != 0) {
                boolean bl = OS.gdk_pixbuf_get_has_alpha(n2);
                if (bl) {
                    int n3 = OS.gdk_pixbuf_get_width(n2);
                    int n4 = OS.gdk_pixbuf_get_height(n2);
                    int n5 = OS.gdk_pixbuf_get_rowstride(n2);
                    int n6 = OS.gdk_pixbuf_get_pixels(n2);
                    byte[] byArray2 = new byte[n5];
                    this.alphaData = new byte[n3 * n4];
                    int n7 = 0;
                    while (n7 < n4) {
                        OS.memmove(byArray2, n6 + n7 * n5, n5);
                        int n8 = 0;
                        while (n8 < n3) {
                            this.alphaData[n7 * n3 + n8] = byArray2[n8 * 4 + 3];
                            byArray2[n8 * 4 + 3] = -1;
                            ++n8;
                        }
                        OS.memmove(n6 + n7 * n5, byArray2, n5);
                        ++n7;
                    }
                    this.createAlphaMask(n3, n4);
                }
                int[] nArray = new int[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(n2, nArray, null, 0);
                this.type = 0;
                this.pixmap = nArray[0];
                if (this.pixmap == 0) {
                    SWT.error(2);
                }
                OS.g_object_unref(n2);
                return;
            }
        }
        catch (SWTException sWTException) {}
        this.init(device, new ImageData(string));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void createAlphaMask(int n, int n2) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            this.mask = OS.gdk_pixmap_new(0, this.alpha != -1 ? 1 : n, this.alpha != -1 ? 1 : n2, 8);
            if (this.mask == 0) {
                SWT.error(2);
            }
            int n3 = OS.gdk_gc_new(this.mask);
            if (this.alpha != -1) {
                GdkColor gdkColor = new GdkColor();
                gdkColor.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                OS.gdk_gc_set_foreground(n3, gdkColor);
                OS.gdk_draw_rectangle(this.mask, n3, 1, 0, 0, 1, 1);
            } else {
                int n4 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
                if (n4 == 0) {
                    SWT.error(2);
                }
                GdkImage gdkImage = new GdkImage();
                OS.memmove(gdkImage, n4);
                if (gdkImage.bpl == n) {
                    OS.memmove(gdkImage.mem, this.alphaData, this.alphaData.length);
                } else {
                    byte[] byArray = new byte[gdkImage.bpl];
                    int n5 = 0;
                    while (n5 < n2) {
                        System.arraycopy(this.alphaData, n * n5, byArray, 0, n);
                        OS.memmove(gdkImage.mem + gdkImage.bpl * n5, byArray, (int)gdkImage.bpl);
                        ++n5;
                    }
                }
                OS.gdk_draw_image(this.mask, n3, n4, 0, 0, 0, 0, n, n2);
                OS.g_object_unref(n4);
            }
            OS.g_object_unref(n3);
        }
    }

    void createMask() {
        if (this.mask != 0) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0) {
            SWT.error(2);
        }
    }

    int createMask(ImageData imageData, boolean bl) {
        ImageData imageData2 = imageData.getTransparencyMask();
        byte[] byArray = imageData2.data;
        byte[] byArray2 = bl ? new byte[byArray.length] : byArray;
        int n = 0;
        while (n < byArray2.length) {
            byte by = byArray[n];
            byArray2[n] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            ++n;
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0, byArray2, imageData2.width, imageData2.height);
    }

    void createSurface() {
        if (this.surface != 0) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        if (this.mask != 0 || this.alpha != -1 || this.alphaData != null) {
            int n3 = OS.gdk_pixbuf_new(0, true, 8, n, n2);
            if (n3 == 0) {
                SWT.error(2);
            }
            int n4 = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(n3, this.pixmap, n4, 0, 0, 0, 0, n, n2);
            int n5 = OS.gdk_pixbuf_get_rowstride(n3);
            int n6 = OS.gdk_pixbuf_get_pixels(n3);
            byte[] byArray = new byte[n5];
            if (this.mask != 0 && OS.gdk_drawable_get_depth(this.mask) == 1) {
                int n7 = OS.gdk_pixbuf_new(0, false, 8, n, n2);
                if (n7 == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(n7, this.mask, 0, 0, 0, 0, 0, n, n2);
                int n8 = OS.gdk_pixbuf_get_rowstride(n7);
                int n9 = OS.gdk_pixbuf_get_pixels(n7);
                byte[] byArray2 = new byte[n8];
                int n10 = n6;
                int n11 = n9;
                int n12 = 0;
                while (n12 < n2) {
                    OS.memmove(byArray, n10, n5);
                    OS.memmove(byArray2, n11, n8);
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < n) {
                        if (byArray2[n13 * 3] == 0) {
                            byArray[n14 + 3] = 0;
                            byArray[n14 + 2] = 0;
                            byArray[n14 + 1] = 0;
                            byArray[n14 + 0] = 0;
                        }
                        byte by = byArray[n14];
                        byArray[n14] = byArray[n14 + 2];
                        byArray[n14 + 2] = by;
                        ++n13;
                        n14 += 4;
                    }
                    OS.memmove(n10, byArray, n5);
                    n10 += n5;
                    n11 += n8;
                    ++n12;
                }
                OS.g_object_unref(n7);
            } else if (this.alpha != -1) {
                int n15 = n6;
                int n16 = 0;
                while (n16 < n2) {
                    OS.memmove(byArray, n15, n5);
                    int n17 = 0;
                    int n18 = 0;
                    while (n17 < n) {
                        byArray[n18 + 3] = (byte)this.alpha;
                        int n19 = (byArray[n18 + 0] & 0xFF) * this.alpha + 128;
                        n19 = n19 + (n19 >> 8) >> 8;
                        int n20 = (byArray[n18 + 1] & 0xFF) * this.alpha + 128;
                        n20 = n20 + (n20 >> 8) >> 8;
                        int n21 = (byArray[n18 + 2] & 0xFF) * this.alpha + 128;
                        n21 = n21 + (n21 >> 8) >> 8;
                        byArray[n18 + 0] = (byte)n21;
                        byArray[n18 + 1] = (byte)n20;
                        byArray[n18 + 2] = (byte)n19;
                        ++n17;
                        n18 += 4;
                    }
                    OS.memmove(n15, byArray, n5);
                    n15 += n5;
                    ++n16;
                }
            } else if (this.alphaData != null) {
                int n22 = n6;
                int n23 = 0;
                while (n23 < nArray2[0]) {
                    OS.memmove(byArray, n22, n5);
                    int n24 = 0;
                    int n25 = 0;
                    while (n24 < n) {
                        int n26 = this.alphaData[n23 * nArray[0] + n24] & 0xFF;
                        byArray[n25 + 3] = (byte)n26;
                        int n27 = (byArray[n25 + 0] & 0xFF) * n26 + 128;
                        n27 = n27 + (n27 >> 8) >> 8;
                        int n28 = (byArray[n25 + 1] & 0xFF) * n26 + 128;
                        n28 = n28 + (n28 >> 8) >> 8;
                        int n29 = (byArray[n25 + 2] & 0xFF) * n26 + 128;
                        n29 = n29 + (n29 >> 8) >> 8;
                        byArray[n25 + 0] = (byte)n29;
                        byArray[n25 + 1] = (byte)n28;
                        byArray[n25 + 2] = (byte)n27;
                        ++n24;
                        n25 += 4;
                    }
                    OS.memmove(n22, byArray, n5);
                    n22 += n5;
                    ++n23;
                }
            } else {
                int n30 = n6;
                int n31 = 0;
                while (n31 < nArray2[0]) {
                    OS.memmove(byArray, n30, n5);
                    int n32 = 0;
                    int n33 = 0;
                    while (n32 < n) {
                        byArray[n33 + 3] = -1;
                        byte by = byArray[n33];
                        byArray[n33] = byArray[n33 + 2];
                        byArray[n33 + 2] = by;
                        ++n32;
                        n33 += 4;
                    }
                    OS.memmove(n30, byArray, n5);
                    n30 += n5;
                    ++n31;
                }
            }
            this.surfaceData = OS.g_malloc(n5 * n2);
            OS.memmove(this.surfaceData, n6, n5 * n2);
            this.surface = Cairo.cairo_image_surface_create_for_data(this.surfaceData, 0, n, n2, n5);
            OS.g_object_unref(n3);
        } else {
            int n34 = OS.GDK_DISPLAY();
            int n35 = OS.GDK_PIXMAP_XID(this.pixmap);
            int n36 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(n34, n35, n36, n, n2);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0;
    }

    public void dispose() {
        if (this.pixmap == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        if (this.surfaceData != 0) {
            OS.g_free(this.surfaceData);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.surface = 0;
        this.surfaceData = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        this.width = nArray[0];
        this.height = nArray2[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int n3 = OS.gdk_pixbuf_new(0, false, 8, n, n2);
        if (n3 == 0) {
            SWT.error(2);
        }
        int n4 = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(n3, this.pixmap, n4, 0, 0, 0, 0, n, n2);
        int n5 = OS.gdk_pixbuf_get_rowstride(n3);
        int n6 = OS.gdk_pixbuf_get_pixels(n3);
        byte[] byArray = new byte[n5 * n2];
        OS.memmove(byArray, n6, byArray.length);
        OS.g_object_unref(n3);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, 24, paletteData);
        imageData.data = byArray;
        imageData.bytesPerLine = n5;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int n7;
            int n8 = OS.gdk_drawable_get_image(this.mask, 0, 0, n, n2);
            if (n8 == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, n8);
            byte[] byArray2 = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(byArray2, gdkImage.mem, byArray2.length);
            OS.g_object_unref(n8);
            int n9 = 1;
            while (n9 < 128) {
                n7 = ((n + 7) / 8 + (n9 - 1)) / n9 * n9;
                if (gdkImage.bpl == n7) break;
                ++n9;
            }
            imageData.maskPad = 2;
            byArray2 = ImageData.convertPad(byArray2, n, n2, 1, n9, imageData.maskPad);
            if (gdkImage.byte_order == 0) {
                n7 = 0;
                while (n7 < byArray2.length) {
                    byte by = byArray2[n7];
                    byArray2[n7] = (byte)((by & 1) << 7 | (by & 2) << 5 | (by & 4) << 3 | (by & 8) << 1 | (by & 0x10) >> 1 | (by & 0x20) >> 3 | (by & 0x40) >> 5 | (by & 0x80) >> 7);
                    ++n7;
                }
            }
            imageData.maskData = byArray2;
        }
        imageData.transparentPixel = this.transparentPixel;
        imageData.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            imageData.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
        }
        return imageData;
    }

    public static Image gtk_new(Device device, int n, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = n;
        image.pixmap = n2;
        image.mask = n3;
        image.device = device;
        return image;
    }

    public int hashCode() {
        return this.pixmap;
    }

    void init(Device device, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n, n2, -1);
        if (this.pixmap == 0) {
            SWT.error(2);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)-1;
        gdkColor.green = (short)-1;
        gdkColor.blue = (short)-1;
        int n3 = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(n3, gdkColor, true, true);
        int n4 = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(n4, gdkColor);
        OS.gdk_draw_rectangle(this.pixmap, n4, 1, 0, 0, n, n2);
        OS.g_object_unref(n4);
        OS.gdk_colormap_free_colors(n3, gdkColor, 1);
    }

    void init(Device device, ImageData imageData) {
        boolean bl;
        Object object;
        int n;
        int n2;
        if (imageData == null) {
            SWT.error(4);
        }
        this.device = device;
        int n3 = imageData.width;
        int n4 = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        if ((n2 = OS.gdk_pixbuf_new(0, false, 8, n3, n4)) == 0) {
            SWT.error(2);
        }
        int n5 = OS.gdk_pixbuf_get_rowstride(n2);
        int n6 = OS.gdk_pixbuf_get_pixels(n2);
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != 24 || n5 != imageData.bytesPerLine || paletteData.redMask != 0xFF0000 || paletteData.greenMask != 65280 || paletteData.blueMask != 255) {
            byArray = new byte[n5 * n4];
            if (paletteData.isDirect) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n3, n4, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray, 24, n5, 1, 0, 0, n3, n4, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                n = rGBArray.length;
                byte[] byArray2 = new byte[n];
                object = new byte[n];
                byte[] byArray3 = new byte[n];
                int n7 = 0;
                while (n7 < rGBArray.length) {
                    RGB rGB = rGBArray[n7];
                    if (rGB != null) {
                        byArray2[n7] = (byte)rGB.red;
                        object[n7] = (byte)rGB.green;
                        byArray3[n7] = (byte)rGB.blue;
                    }
                    ++n7;
                }
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, n3, n4, byArray2, object, byArray3, 255, null, 0, 0, 0, byArray, 24, n5, 1, 0, 0, n3, n4, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(n6, byArray, n5 * n4);
        int n8 = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), n3, n4, -1);
        if (n8 == 0) {
            SWT.error(2);
        }
        if ((n = OS.gdk_gc_new(n8)) == 0) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(n2, n8, n, 0, 0, 0, 0, n3, n4, 1, 0, 0);
        OS.g_object_unref(n);
        OS.g_object_unref(n2);
        boolean bl2 = bl = imageData.getTransparencyType() == 2;
        if (bl || imageData.transparentPixel != -1) {
            int n9;
            if (imageData.transparentPixel != -1) {
                object = null;
                if (paletteData.isDirect) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    object = paletteData.getRGB(imageData.transparentPixel);
                }
                if (object != null) {
                    this.transparentPixel = object.red << 16 | object.green << 8 | object.blue;
                }
            }
            if ((n9 = this.createMask(imageData, bl)) == 0) {
                SWT.error(2);
            }
            this.mask = n9;
            this.type = bl ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = imageData.alpha;
            if (imageData.alpha == -1 && imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(n3, n4);
        }
        this.pixmap = n8;
    }

    public int internal_new_GC(GCData gCData) {
        if (this.pixmap == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int n = OS.gdk_gc_new(this.pixmap);
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.device = this.device;
            gCData.drawable = this.pixmap;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont.handle;
            gCData.image = this;
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.g_object_unref(n);
    }

    public boolean isDisposed() {
        return this.pixmap == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

