/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Table;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    int scrollIndex;
    long scrollBeginTime;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        int n = table.handle;
        OS.gtk_tree_view_unset_rows_drag_dest(n);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        int n;
        Table table = (Table)this.control;
        int n2 = table.handle;
        int n3 = this.checkEffect(dropTargetEvent.feedback);
        Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
        point = table.toControl(point);
        int[] nArray = new int[1];
        OS.gtk_tree_view_get_path_at_pos(n2, point.x, point.y, nArray, null, null, null);
        int n4 = -1;
        if (nArray[0] != 0 && (n = OS.gtk_tree_path_get_indices(nArray[0])) != 0) {
            int[] nArray2 = new int[1];
            OS.memmove(nArray2, n, 4);
            n4 = nArray2[0];
        }
        if ((n3 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n4 != -1 && this.scrollIndex == n4 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                if (point.y < table.getItemHeight()) {
                    OS.gtk_tree_path_prev(nArray[0]);
                } else {
                    OS.gtk_tree_path_next(nArray[0]);
                }
                if (nArray[0] != 0) {
                    OS.gtk_tree_view_scroll_to_cell(n2, nArray[0], 0, false, 0.0f, 0.0f);
                    OS.gtk_tree_path_free(nArray[0]);
                    nArray[0] = 0;
                    OS.gtk_tree_view_get_path_at_pos(n2, point.x, point.y, nArray, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = n4;
        }
        if (nArray[0] != 0) {
            n = 0;
            if ((n3 & 1) != 0) {
                n = 2;
            }
            if (n != 0) {
                OS.gtk_tree_view_set_drag_dest_row(n2, nArray[0], 2);
            } else {
                OS.gtk_tree_view_unset_rows_drag_dest(n2);
            }
        } else {
            OS.gtk_tree_view_unset_rows_drag_dest(n2);
        }
        if (nArray[0] != 0) {
            OS.gtk_tree_path_free(nArray[0]);
        }
    }
}

