/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkColorSelectionDialog;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 0);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, parent == null ? style : ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        boolean success;
        Display display;
        byte[] buffer = Converter.wcsToMbcs(null, this.title, true);
        int handle = OS.gtk_color_selection_dialog_new(buffer);
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(handle, 2);
            OS.gtk_container_forall(handle, display.setDirectionProc, 2);
        }
        if (this.parent != null) {
            int shellHandle = this.parent.topHandle();
            OS.gtk_window_set_transient_for(handle, shellHandle);
            int pixbufs = OS.gtk_window_get_icon_list(shellHandle);
            if (pixbufs != 0) {
                OS.gtk_window_set_icon_list(handle, pixbufs);
                OS.g_list_free(pixbufs);
            }
        }
        GtkColorSelectionDialog dialog = new GtkColorSelectionDialog();
        OS.memmove(dialog, handle);
        GdkColor color = new GdkColor();
        if (this.rgb != null) {
            color.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
            color.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
            color.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
            OS.gtk_color_selection_set_current_color(dialog.colorsel, color);
        }
        OS.gtk_color_selection_set_has_palette(dialog.colorsel, true);
        display.addIdleProc();
        Dialog oldModal = null;
        if (OS.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int response = OS.gtk_dialog_run(handle);
        if (OS.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = response == -5;
        if (success) {
            OS.gtk_color_selection_get_current_color(dialog.colorsel, color);
            int red = color.red >> 8 & 0xFF;
            int green = color.green >> 8 & 0xFF;
            int blue = color.blue >> 8 & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(handle);
        if (!success) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

