/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klNative_wgl.h,v 1.1.1.1 2003/12/10 17:07:28 drgoldie Exp $
 *
\**************************************************************************/


#ifdef __cplusplus
extern "C" {
#endif


//
// in order not to mess with windows functions from <windows.h>
// under x86 we name our methods xxx_kl and have a
// #define statement to correct this behavior in gl.h
//


/// wglCreateContext creates a new OpenGL rendering context
/**
 *   Klimt does not provide thread-specific contexts.
 */
KLIMT_API HGLRC wglCreateContext_kl(HDC hdc)
{
	klRasterizer* rasterizer = new klRasterizer;

	klEGLSurface* surface = new klEGLSurfaceWindow();
	surface->setNativeDisplay(hdc);

	rasterizer->setSurface(surface);
	return (HGLRC)new klContext(rasterizer);
}


/// wglCreateContext destroys an OpenGL rendering context
/**
 *   Klimt does not provide thread-specific contexts.
 */
KLIMT_API BOOL wglDeleteContext_kl(HGLRC hglrc)
{
	klContext* ctx = (klContext*)hglrc;

	if(ctx==NULL)
		return GL_FALSE;

	if(ctx->getRasterizer()!=NULL && ctx->getRasterizer()->getSurface()!=NULL)
	{
		klEGLSurface* surface = ctx->getRasterizer()->getSurface();
		if(surface)
		{
			surface->destroy();
			delete surface;
		}
		currentContext->getRasterizer()->setSurface(NULL);
	}

	delete ctx;
	return GL_TRUE;
}


/// wglMakeCurrent function makes a specified context the current context
/**
 *   Klimt does not provide thread-specific contexts.
 */
KLIMT_API BOOL wglMakeCurrent_kl(HDC hdc, HGLRC hglrc)
{
	currentContext = (klContext*)hglrc;

	if(currentContext==NULL ||
	   currentContext->getRasterizer()==NULL ||
	   currentContext->getRasterizer()->getSurface()==NULL)
		return GL_FALSE;

	klEGLSurface* surface = currentContext->getRasterizer()->getSurface();

	if(surface)
	{
		// do a quick check if we don't have to recreate the surface...
		//
		if(surface->getNativeDisplay()==hdc)
			return GL_TRUE;

		surface->destroy();
		surface->setNativeDisplay(hdc);
	}
	return currentContext->getRasterizer()->setSurface(surface) ? GL_TRUE : GL_FALSE;
}


/// wglGetCurrentContext returns a handle to the current rendering context 
/**
 *   Klimt does not provide thread-specific contexts.
 */
KLIMT_API HGLRC wglGetCurrentContext_kl()
{
	return (HGLRC)currentContext;
}


/// wglGetProcAddress returns the address of an OpenGL extension function
/**
 *   Klimt currently always returns NULL
 */
KLIMT_API void* wglGetProcAddress_kl(LPCSTR lpszProc)
{
	return NULL;
}


/// wglGetCurrentDC returns a handle to the device context that is associated rendering context
/**
 *   Works as specified.
 */
KLIMT_API HDC wglGetCurrentDC_kl()
{
	if(currentContext==NULL ||
	   currentContext->getRasterizer()==NULL ||
	   currentContext->getRasterizer()->getSurface()==NULL)
		return GL_FALSE;

	klEGLSurface* surface = currentContext->getRasterizer()->getSurface();
	return surface->getNativeDisplay();
}


/// SwapBuffers exchanges the front and back buffers
/**
 *   Works as specified.
 */
KLIMT_API BOOL SwapBuffers_kl(HDC hdc)
{
	if(currentContext==NULL ||
	   currentContext->getRasterizer()==NULL ||
	   currentContext->getRasterizer()->getSurface()==NULL)
		return EGL_FALSE;

	klEGLSurface* surface = currentContext->getRasterizer()->getSurface();

	if(!surface->flip())
		return EGL_FALSE;

	// need to set the surface again since it might have changed
	// some attributes (e.g. color buffer)
	return currentContext->getRasterizer()->setSurface(surface) ? GL_TRUE : GL_FALSE;
}


#ifdef __cplusplus
}
#endif
