/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klMain.cpp,v 1.2 2004/02/10 18:19:30 drgoldie Exp $
 *
\**************************************************************************/

#include "../include/klMain.h"

#ifdef _IS_WINDOWS_
	#include <windows.h>
	#include "../include/wgl_definitions.h"

	BOOL APIENTRY DllMain(HANDLE /*hModule*/, DWORD  ul_reason_for_call, LPVOID /*lpReserved*/)
	{
	  switch (ul_reason_for_call)
	  {
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}
	return TRUE;
	}
#endif //_IS_WINDOWS_

#include "../include/gl_definitions.h"

#include "Base/klMath.h"
#include "Base/klStack.h"
#include "Base/klArray.h"

// before we can use klRasterizerSW565 we need to provide
// a display class that abstracts the window/display
//
#include "klEGLSurfaceNative.h"
#include "klEGLSurfaceBuffer.h"

// currently we only have a
// 16bits-RGB565 rasterizer
//
#include "RasterizerSW565/klRSW565.h"
typedef klRSW565 klRasterizer;


// the one and only place where we include
// all the context stuff...
//
#include "klContext.h"

// this is the current context
//
klContext *currentContext = NULL;

// include implementation of the C-wrapper functions
//
#include "klWrapper.h"

// include implementation of wgl functions
//
#ifdef _IS_WINDOWS_
  #include "klNative_wgl.h"
#endif //

// include implementation of egl functions
//
#include "../include/egl_definitions.h"
#include "klNative_egl.h"
