/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klImageConverter.h,v 1.1.1.1 2003/12/10 17:07:28 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __IMAGECONVERTER_HEADERFILE__
#define __IMAGECONVERTER_HEADERFILE__


/// ImageConverter convertes between different types of graphics formats
//  It does so by using function pointers to read and write source and 
//  destination formats.
class klImageConverter
{
public:
	static void* convert(int nWidth, int nHeight, const void* nFromPixels,
						 int nFromNumComp, int nFromFormat, int nFromDataType,
						 int nToNumComp, int nToFormat, int nToDataType);
protected:
	// intermediate pixel storage in RGBA8888
	struct PIXEL {
		unsigned char red, green, blue, alpha;
	};

	typedef int (*READFUNC)(const void* nData, PIXEL& nPixel);
	typedef int (*WRITEFUNC)(void* nData, const PIXEL& nPixel);

	static int getNumPixelBytes(int nNumComp, int nDataType);

	static READFUNC getReadFunc(int nFromNumComp, int nFromFormat, int nFromDataType);
	static WRITEFUNC getWriteFunc(int nFromNumComp, int nFromFormat, int nFromDataType);


	// currently we only have support for RGB888 and similiar.
	//
	static int readRGB888(const void* nData, PIXEL& nPixel);
	static int readRGBX8888(const void* nData, PIXEL& nPixel);
	static int readRGBA8888(const void* nData, PIXEL& nPixel);

	static int writeRGB888(void* nData, const PIXEL& nPixel);
	static int writeRGBX8888(void* nData, const PIXEL& nPixel);
	static int writeRGBA8888(void* nData, const PIXEL& nPixel);
};


#endif //__IMAGECONVERTER_HEADERFILE__
