/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klEGLSurface.h,v 1.2 2004/01/13 11:20:09 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLEGLSURFACE_HEADERFILE__
#define __KLEGLSURFACE_HEADERFILE__


#include "../include/egl_definitions.h"


/// Klimt implementation for EGLSurface
/**
 *  This is the base class for all EGLSurface
 *  implementations.
 */

class klEGLSurface
{
public:
	enum COLOR_TYPE
	{
		COLOR_TYPE_RGB555,
		COLOR_TYPE_RGB565,
		COLOR_TYPE_RGB888,
		COLOR_TYPE_RGBX8888
	};

	enum DEPTH_TYPE
	{
		DEPTH_TYPE_INT16,
		DEPTH_TYPE_INT32
	};

	virtual ~klEGLSurface()  {}

	virtual int getWidth() const  {  return width;  }
	virtual int getHeight() const  {  return height;  }

	virtual void* getColorBuffer() const  {  return cBuffer;  }
	virtual void* getDepthBuffer() const  {  return zBuffer;  }

	virtual COLOR_TYPE getColorType() const  {  return colorType;  }
	virtual DEPTH_TYPE getDepthType() const  {  return depthType;  }

	// open to be implemented by a subclass
	//
	virtual bool setNativeWindow(NativeWindowType nWnd) = 0;
	virtual bool setNativeDisplay(NativeDisplayType nDisp) = 0;

	virtual NativeWindowType getNativeWindow() = 0;
	virtual NativeDisplayType getNativeDisplay() = 0;

	virtual bool destroy() = 0;
	virtual bool flip() = 0;

protected:
	int   width,height;
	void* cBuffer;
	void* zBuffer;

	COLOR_TYPE colorType;
	DEPTH_TYPE depthType;

	klEGLSurface()   {} 			// prevent klEGLSurface from beeing instantiated
};


#endif //__KLEGLSURFACE_HEADERFILE__
