/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglSetup.h,v 1.5 2004/01/28 10:28:47 drgoldie Exp $
 *
\**************************************************************************/


/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//               general state manipulation
//

void glClearColor(GLclampf nR, GLclampf nG, GLclampf nB, GLclampf nA)
{
	klColor4 col;
	col.setFloat(nR, nG, nB, nA);

	RECORD_DISPLAYLISTS1(ClearColor, clearColor)
	if(!displaylist.executeCommands)
		return;

	clearColor = col;
	rasterizer->setClearColor(col);
}


void glClearColorx(GLfixed nR, GLfixed nG, GLfixed nB, GLfixed nA)
{
	klColor4 col;
	col.setFixed(nR,nG,nB,nA);

	RECORD_DISPLAYLISTS1(ClearColor, clearColor)
	if(!displaylist.executeCommands)
		return;

	clearColor = col;
	rasterizer->setClearColor(col);
}


void glClearColor(const klVec4& nColor)
{
	clearColor = nColor;
	rasterizer->setClearColor(nColor);
}


void glClearDepth(GLclampd nDepth)
{
	klFloat depth;
	depth.setDouble(nDepth);

	RECORD_DISPLAYLISTS1(ClearDepth, clearDepth)
	if(!displaylist.executeCommands)
		return;

	clearDepth = depth;
	rasterizer->setClearDepth(depth);
}


void glClearDepthx(GLfixed nDepth)
{
	klFloat depth;
	depth.setFixed(nDepth);

	RECORD_DISPLAYLISTS1(ClearDepth, clearDepth)
	if(!displaylist.executeCommands)
		return;

	clearDepth = depth;
	rasterizer->setClearDepth(depth);
}


void glClearDepth(const klFloat& nDepth)
{
	clearDepth = nDepth;
	rasterizer->setClearDepth(clearDepth);

	RECORD_DISPLAYLISTS1(ClearDepth, clearDepth)
}


void glClear(int nFlags)
{
	RECORD_DISPLAYLISTS1(Clear, nFlags)
	if(!displaylist.executeCommands)
		return;

	rasterizer->clear(nFlags);
}


void glColorMask(GLboolean nRed, GLboolean nGreen, GLboolean nBlue, GLboolean nAlpha)
{
	RECORD_DISPLAYLISTS4(ColorMask, nRed,nGreen,nBlue,nAlpha)
	if(!displaylist.executeCommands)
		return;

	colorMask =  nRed ? COLOR_MASK_RED : 0;
	colorMask |= nGreen ? COLOR_MASK_GREEN : 0;
	colorMask |= nBlue ? COLOR_MASK_BLUE : 0;
	colorMask |= nAlpha ? COLOR_MASK_ALPHA : 0;
}


void glEnable(GLenum nSelect)
{
	int i;
	RECORD_DISPLAYLISTS1(Enable, nSelect)
	if(!displaylist.executeCommands)
		return;

	switch(nSelect)
	{
	case GL_CULL_FACE:
		cullingEnabled = true;
		return;

	case GL_LIGHTING:
		lightingEnabled = true;
		return;

	case GL_LIGHT0:
	case GL_LIGHT1:
	case GL_LIGHT2:
	case GL_LIGHT3:
	case GL_LIGHT4:
	case GL_LIGHT5:
	case GL_LIGHT6:
	case GL_LIGHT7:
		lights[nSelect-GL_LIGHT0].enabled = true;
		for(largestActiveLightIdx=-1,i=MAX_LIGHTS-1; i>=0; i--)
			if(lights[i].enabled)
			{	largestActiveLightIdx = i;	break;	}
		return;

	case GL_DEPTH_TEST:
		depthTestEnabled = true;
		return;

	case GL_TEXTURE_2D:
		texturingEnabled = true;
		return;

	case GL_COLOR_MATERIAL:
		colorMaterialEnabled = true;
		return;

	case GL_NORMALIZE:
		normalizeNormalsEnabled = tweak.allowNormalization;
		return;

	case GL_SCISSOR_TEST:
		scissor.enabled = true;
		rasterizer->set2DClippingEnabled(true);
		break;

	case GL_FOG:
		fog.enabled = true;
		break;

	case GL_BLEND:
		blend.enabled = true;
		break;

	case GL_AUTO_NORMAL:
	case GL_POINT_SMOOTH:
	case GL_LINE_SMOOTH:
	case GL_LINE_STIPPLE:
	case GL_POLYGON_STIPPLE:
	case GL_TEXTURE_GEN_S:
	case GL_TEXTURE_GEN_T:
	case GL_TEXTURE_GEN_Q:
	case GL_TEXTURE_GEN_R:
	case GL_CLIP_PLANE0:
	case GL_POLYGON_OFFSET_POINT:
	case GL_POLYGON_OFFSET_LINE:
	case GL_POLYGON_OFFSET_FILL:
	case GL_ALPHA_TEST:
		// ignore this silently...
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glEnable(): unknown parameter '%d'", (int)nSelect);
		// unknown parameter
		return;
	}
}


void glDisable(GLenum nSelect)
{
	int i;
	RECORD_DISPLAYLISTS1(Disable, nSelect)
	if(!displaylist.executeCommands)
		return;

	switch(nSelect)
	{
	case GL_CULL_FACE:
		cullingEnabled = (false | tweak.forceCulling);
		return;

	case GL_LIGHTING:
		lightingEnabled = false;
		return;

	case GL_LIGHT0:
	case GL_LIGHT1:
	case GL_LIGHT2:
	case GL_LIGHT3:
	case GL_LIGHT4:
	case GL_LIGHT5:
	case GL_LIGHT6:
	case GL_LIGHT7:
		lights[nSelect-GL_LIGHT0].enabled = false;
		for(largestActiveLightIdx=-1,i=MAX_LIGHTS-1; i>=0; i--)
			if(lights[i].enabled)
			{	largestActiveLightIdx = i;	break;	}
		return;

	case GL_DEPTH_TEST:
		depthTestEnabled = false;
		return;

	case GL_TEXTURE_2D:
		texturingEnabled = false;
		return;

	case GL_COLOR_MATERIAL:
		colorMaterialEnabled = false;
		return;

	case GL_NORMALIZE:
		normalizeNormalsEnabled = false;
		return;

	case GL_SCISSOR_TEST:
		scissor.enabled = false;
		rasterizer->set2DClippingEnabled(false);
		break;

	case GL_FOG:
		fog.enabled = false;
		break;

	case GL_BLEND:
		blend.enabled = false;
		break;

	case GL_AUTO_NORMAL:
	case GL_POINT_SMOOTH:
	case GL_LINE_SMOOTH:
	case GL_LINE_STIPPLE:
	case GL_POLYGON_STIPPLE:
	case GL_TEXTURE_GEN_S:
	case GL_TEXTURE_GEN_T:
	case GL_TEXTURE_GEN_Q:
	case GL_TEXTURE_GEN_R:
	case GL_CLIP_PLANE0:
	case GL_POLYGON_OFFSET_POINT:
	case GL_POLYGON_OFFSET_LINE:
	case GL_POLYGON_OFFSET_FILL:
	case GL_ALPHA_TEST:
		// ignore this silently...
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glEnable(): unknown parameter '%d'", (int)nSelect);
		// unknown parameter
		return;
	}
}


GLboolean glIsEnabled(GLenum nSelect)
{
	switch(nSelect)
	{
	case GL_CULL_FACE:
		return cullingEnabled ? GL_TRUE : GL_FALSE;

	case GL_LIGHTING:
		return lightingEnabled ? GL_TRUE : GL_FALSE;

	case GL_LIGHT0:
	case GL_LIGHT1:
	case GL_LIGHT2:
	case GL_LIGHT3:
	case GL_LIGHT4:
	case GL_LIGHT5:
	case GL_LIGHT6:
	case GL_LIGHT7:
		return lights[nSelect-GL_LIGHT0].enabled ? GL_TRUE : GL_FALSE;

	case GL_DEPTH_TEST:
		return depthTestEnabled ? GL_TRUE : GL_FALSE;

	case GL_TEXTURE_2D:
		return texturingEnabled ? GL_TRUE : GL_FALSE;

	case GL_COLOR_MATERIAL:
		return colorMaterialEnabled ? GL_TRUE : GL_FALSE;

	case GL_NORMALIZE:
		return normalizeNormalsEnabled ? GL_TRUE : GL_FALSE;

	case GL_SCISSOR_TEST:
		return scissor.enabled ? GL_TRUE : GL_FALSE;

	case GL_FOG:
		return fog.enabled ? GL_TRUE : GL_FALSE;

	case GL_BLEND:
		return blend.enabled ? GL_TRUE : GL_FALSE;

	case GL_POINT_SMOOTH:
	case GL_LINE_SMOOTH:
	case GL_LINE_STIPPLE:
	case GL_POLYGON_STIPPLE:
	case GL_TEXTURE_GEN_S:
	case GL_TEXTURE_GEN_T:
	case GL_TEXTURE_GEN_Q:
	case GL_TEXTURE_GEN_R:
	case GL_CLIP_PLANE0:
	case GL_POLYGON_OFFSET_POINT:
	case GL_POLYGON_OFFSET_LINE:
	case GL_POLYGON_OFFSET_FILL:
	case GL_ALPHA_TEST:
		// ignore this silently...
		return GL_FALSE;

	default:
		// unknown parameter
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glIsEnabled(): unknown parameter '%d'", (int)nSelect);
		return GL_FALSE;
	}

	return GL_FALSE;
}


void glDepthMask(GLboolean nSet)
{
	RECORD_DISPLAYLISTS1(DepthMask, nSet)
	if(!displaylist.executeCommands)
		return;

	depthWriteEnabled = (nSet==GL_TRUE);
}


void glCullFace(GLenum nCull)
{
	RECORD_DISPLAYLISTS1(DepthMask, nCull)
	if(!displaylist.executeCommands)
		return;

	cullMode = nCull;
}


void glFrontFace(GLenum nFace)
{
	RECORD_DISPLAYLISTS1(FrontFace, nFace)
	if(!displaylist.executeCommands)
		return;

	frontFace = nFace;
}


void glGetBooleanv(GLenum nType, GLboolean *nParams)
{
	switch(nType)
	{
	case GL_RGBA_MODE:
		*nParams = GL_TRUE;
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glGetBooleanv(): unknown parameter '%d'", (int)nType);
		break;
	}
}


void glGetFloatv(GLenum nType, GLfloat* nParams)
{
	int i;

	switch(nType)
	{
	case GL_PROJECTION_MATRIX:
		projectionStack.getTop().getFloat(nParams);
		return;

	case GL_MODELVIEW_MATRIX:
		modelviewStack.getTop().getFloat(nParams);
		return;

	case GL_TEXTURE_MATRIX:
		textureStack.getTop().getFloat(nParams);
		return;

	case KL_MODELPROJ_INVTRANS_MATRIX:
		for(i=0; i<16; i++)
			nParams[i] = modelProjMatrixInvTrans[i].getFloat();

	case GL_LIGHT_MODEL_AMBIENT:
		lightModel.ambient.getFloat(nParams);
		return;

	case GL_CURRENT_COLOR:
		beginendState.currentColor.setFloat(nParams);
		return;

	case GL_LINE_WIDTH_RANGE:	
		nParams[0] = 1.0f;
		nParams[1] = 1.0f;
		return;

	case GL_POINT_SIZE_RANGE:
		*nParams = 1.0f;

	case GL_FOG_COLOR:
		fog.color.setFloat(nParams);
		return;

	case GL_FOG_START:
		*nParams = fog.start.getFloat();
		return;

	case GL_FOG_END:
		*nParams = fog.end.getFloat();
		return;

	case GL_MATRIX_MODE:
		if(curStack==&modelviewStack)
			*nParams = (GLfloat)GL_MODELVIEW;
		else if(curStack==&projectionStack)
			*nParams = (GLfloat)GL_PROJECTION;
		else
			*nParams = (GLfloat)GL_TEXTURE;
		return;

	case GL_MAX_ATTRIB_STACK_DEPTH:
		*nParams = (GLfloat)MAX_ATTRIBUTE_STACK;
		return;

	case GL_ATTRIB_STACK_DEPTH:
		*nParams = (GLfloat)attributeStack.getCurrentSize();
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glGetFloatv(): unknown parameter '%d'", (int)nType);
		break;
	}
}


void glGetIntegerv(GLenum nType, GLint* nParams)
{
	switch(nType)
	{
	case GL_FRONT_FACE:
		*nParams = frontFace;
		return;

	case GL_CULL_FACE_MODE:
		*nParams = cullMode;
		return;

	case GL_LIGHT_MODEL_AMBIENT:
		lightModel.ambient.getByte(nParams);
		return;

	case GL_MAX_LIGHTS:
		*nParams = MAX_LIGHTS;
		return;

	case GL_RED_BITS:
		*nParams = 5;
		return;

	case GL_GREEN_BITS:
		*nParams = 6;
		return;

	case GL_BLUE_BITS:
		*nParams = 5;
		return;

	case GL_ALPHA_BITS:
		*nParams = 0;
		return;

	case GL_MAX_VIEWPORT_DIMS:
		nParams[0] = rasterizer->getWidth();
		nParams[1] = rasterizer->getHeight();
		return;

	case GL_MAX_CLIP_PLANES:
		*nParams = 0;
		return;

	case GL_MAX_TEXTURE_SIZE:
		*nParams = 512;
		return;

	case GL_FOG_MODE:
		*nParams = GL_LINEAR;
		return;

	case GL_FOG_COLOR:
		fog.color.getByte(nParams);			// TODO: this is wrong (full 32-bits not 8-bits)
		return;

	case GL_FOG_START:
		*nParams = fog.start.getByte();		// TODO: this is wrong (full 32-bits not 8-bits)
		return;

	case GL_FOG_END:
		*nParams = fog.end.getByte();		// TODO: this is wrong (full 32-bits not 8-bits)
		return;

	case GL_MATRIX_MODE:
		if(curStack==&modelviewStack)
			*nParams = GL_MODELVIEW;
		else if(curStack==&projectionStack)
			*nParams = GL_PROJECTION;
		else
			*nParams = GL_TEXTURE;
		return;

	case GL_MAX_ATTRIB_STACK_DEPTH:
		*nParams = MAX_ATTRIBUTE_STACK;
		return;

	case GL_ATTRIB_STACK_DEPTH:
		*nParams = attributeStack.getCurrentSize();
		return;

	case GL_LIST_BASE:
		*nParams = displaylist.listBase;
		return;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glGetIntegerv(): unknown parameter '%d'", (int)nType);
		break;
	}
}


const GLubyte* glGetString(GLenum nName)
{
	switch(nName)
	{
	case GL_VENDOR:
		return (const GLubyte*)"IMS";

	case GL_RENDERER:
		return (const GLubyte*)"Klimt";

	case GL_VERSION:
		return (const GLubyte*)"0.4.2";

	case GL_EXTENSIONS:
		return (const GLubyte*)"";
	}

	return (const GLubyte*)"";
}


void glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
	RECORD_DISPLAYLISTS4(Scissor, x,y,width,height)
	if(!displaylist.executeCommands)
		return;

	scissor.x = x;
	scissor.y = y;
	scissor.width = width;
	scissor.height = height;

	rasterizer->set2DClipping(x,rasterizer->getHeight()-(y+height),
							  x+width,rasterizer->getHeight()-y);
}


void glFogi(GLenum pname, GLint param)
{
	klFloat p;
	p.setInt(param);				// is this correct? (so only 0 & 1 make sense...)

	switch(pname)
	{
	case GL_FOG_MODE:
		//
		// TODO: implement missing fog modes (currently only linear, do we even want other modes?)
		//
		break;

	case GL_FOG_START:
		RECORD_DISPLAYLISTS2(Fog, pname, p)
		if(!displaylist.executeCommands)
			return;

		fog.start = p;
		fog.update();
		break;

	case GL_FOG_END:
		RECORD_DISPLAYLISTS2(Fog, pname, p)
		if(!displaylist.executeCommands)
			return;

		fog.end = p;
		fog.update();
		break;
	}
}


void glFogf(GLenum pname, float param)
{
	klFloat p;
	p.setFloat(param);

	switch(pname)
	{
	case GL_FOG_MODE:
		// ignore this, our fog is currently always linear...
		break;

	case GL_FOG_START:
		RECORD_DISPLAYLISTS2(Fog, pname, p)
		if(!displaylist.executeCommands)
			return;

		fog.start = p;
		fog.update();
		break;

	case GL_FOG_END:
		RECORD_DISPLAYLISTS2(Fog, pname, p)
		if(!displaylist.executeCommands)
			return;

		fog.end = p;
		fog.update();
		break;
	}
}


void glFog(GLenum pname, const klFloat& param)
{
	switch(pname)
	{
	case GL_FOG_MODE:
		//
		// TODO: implement missing fog modes (currently only linear, do we even want other modes?)
		//
		break;

	case GL_FOG_START:
		fog.start = param;				// is this correct? (so only 0 & 1 make sense...)
		fog.update();
		break;

	case GL_FOG_END:
		fog.end = param;				// is this correct? (so only 0 & 1 make sense...)
		fog.update();
		break;
	}
}


void glFogfv(GLenum pname, const float *params)
{
	klFloat f;
	klVec4 v;

	switch(pname)
	{
	case GL_FOG_MODE:
		// ignore this, our fog is currently always linear...
		break;

	case GL_FOG_START:
		f.setFloat(*params);
		RECORD_DISPLAYLISTS2(Fog, pname, f)
		if(!displaylist.executeCommands)
			return;

		fog.start = f;
		fog.update();
		break;

	case GL_FOG_END:
		f.setFloat(*params);
		RECORD_DISPLAYLISTS2(Fog, pname, f)
		if(!displaylist.executeCommands)
			return;

		fog.end = f;
		fog.update();
		break;

	case GL_FOG_COLOR:
		v.setFloat(params);
		RECORD_DISPLAYLISTS1(FogColor, v)
		if(!displaylist.executeCommands)
			return;

		fog.color = v;
		rasterizer->setFogColor(v);
		break;
	}
}


void glFogiv(GLenum pname, const int *params)
{
	klFloat f;
	klVec4 v;

	switch(pname)
	{
	case GL_FOG_MODE:
		// ignore this, our fog is currently always linear...
		break;

	case GL_FOG_START:
		f.setInt(*params);
		RECORD_DISPLAYLISTS2(Fog, pname, f)
		if(!displaylist.executeCommands)
			return;

		fog.start = f;
		fog.update();
		break;

	case GL_FOG_END:
		f.setInt(*params);
		RECORD_DISPLAYLISTS2(Fog, pname, f)
		if(!displaylist.executeCommands)
			return;

		fog.end = f;
		fog.update();
		RECORD_DISPLAYLISTS2(Fog, pname, f)
		break;

	case GL_FOG_COLOR:
		v.setInt(params);
		RECORD_DISPLAYLISTS1(FogColor, v)
		if(!displaylist.executeCommands)
			return;

		fog.color = v;
		rasterizer->setFogColor(v);
		break;
	}
}


void glFogColor(const klColor4& color)
{
	fog.color = color;
}


void glBlendFunc(GLenum sfactor, GLenum dfactor)
{
	RECORD_DISPLAYLISTS2(BlendFunc, sfactor,dfactor)
	if(!displaylist.executeCommands)
		return;

	blend.src = sfactor;
	blend.dst = dfactor;
}


void glDepthFunc(GLenum nFunc)
{
	RECORD_DISPLAYLISTS1(DepthFunc, nFunc)
	if(!displaylist.executeCommands)
		return;

	//
	// TODO: do we really need to have an extra enum for this?
	//
	switch(nFunc)
	{
	case GL_NEVER:
		depthFunc = RASTER_ZTEST_NEVER;
		break;

	case GL_LESS:
		depthFunc = RASTER_ZTEST_LESS;
		break;

	case GL_LEQUAL:
		depthFunc = RASTER_ZTEST_LEQUAL;
		break;

	case GL_EQUAL:
		depthFunc = RASTER_ZTEST_EQUAL;
		break;

	case GL_GREATER:
		depthFunc = RASTER_ZTEST_GREATER;
		break;

	case GL_NOTEQUAL:
		depthFunc = RASTER_ZTEST_NOTEQUAL;
		break;

	case GL_GEQUAL:
		depthFunc = RASTER_ZTEST_GEQUAL;
		break;

	case GL_ALWAYS:
		depthFunc = RASTER_ZTEST_ALWAYS;
		break;
	}
}


/**
}  // class klContext
*/
