/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglPixels.h,v 1.3 2004/01/13 15:40:57 drgoldie Exp $
 *
\**************************************************************************/


/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//                pixel reading/writing
//

void glDrawPixels(GLsizei nWidth, GLsizei nHeight, GLenum nFormat, GLenum nType, const GLvoid *nPixels)
{
	// currently we only have a simple full screen draw pixels implementation
	//
	// TODO: glDrawPixels has currently almost no spec conformance
	//

	RECORD_DISPLAYLISTS5(DrawPixels, nWidth, nHeight, nFormat, nType, nPixels)
	if(!displaylist.executeCommands)
		return;

	// Rasterizer's drawPixels() expects RGBX8888 format
	rasterizer->drawPixels(nPixels);
}


void glReadPixels(GLint /*x*/, GLint /*y*/, GLsizei /*width*/, GLsizei /*height*/, GLenum /*format*/, GLenum /*type*/, GLvoid* /*pixels*/)
{
	//
	// TODO: implement glReadPixels
	//
}



/**
}  // class klContext
*/
