/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klContext_oglDisplayList.h,v 1.4 2004/01/27 08:17:50 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/

//
// This file holds all opengl functions that deal with
//
//                  display lists
//


//
// ToDo: we should use a hashtable to speedup the search of display lists (findListIdx())
//
int
calcDisplayListHash(GLuint listname)
{
	return listname&(DISPLAYLIST_MAXHASH-1);
}

/*int
findListIdx(GLuint listname)
{
	int hash = calcDisplayListHash(listname);
	klPtrList<klDisplayList>& dplList = displaylist.nameHashTable[hash];

	int i,num=dplList.getSize();

	for(i=0; i<num; i++)
		if(dplList[i]->getName()==listname)
			return i;

	return -1;
}*/


klDisplayList*
findList(GLuint listname)
{
	int hash = calcDisplayListHash(listname);
	klPtrList<klDisplayList>& dplList = displaylist.nameHashTable[hash];

	int i,num=dplList.getSize();

	for(i=0; i<num; i++)
		if(dplList[i]->getName()==listname)
			return dplList[i];

	return NULL;
}


void glNewList(GLuint list, GLenum mode)
{
	klDisplayList* newList = findList(list);

	if(newList)
		newList->reset();
	else
	{
		newList = new klDisplayList(list, this);
		displaylist.lists.addTail(newList);
		displaylist.nameHashTable[calcDisplayListHash(list)].addTail(newList);
	}

	displaylist.recording = newList;

	displaylist.executeCommands = (mode==GL_COMPILE_AND_EXECUTE);
}


void glEndList()
{
	displaylist.recording = NULL;
	displaylist.executeCommands = true;
}


void glCallList(GLuint list)
{
	klDisplayList* dpl = findList(list);

	if(dpl)
	{
		// for proper display list execution we have to force
		// turning off recording and turning on command execution
		//
		klDisplayList* rec = displaylist.recording;		// store whether displaylist recording is currently active
		displaylist.recording = NULL;					// turn off display list recording during play-back

		bool exec = displaylist.executeCommands;		// store whether command execution is currently active
		displaylist.executeCommands = true;				// turn on command execution during play-back

		dpl->execute();

		displaylist.executeCommands = exec;				// restore the old command execution state
		displaylist.recording = rec;					// restore the old recording state
	}
}


void glCallLists(GLsizei n, GLenum type, const GLvoid *lists)
{
	const unsigned char	*src = static_cast<const unsigned char*>(lists);
	unsigned int		listname = 0;
	int					i;

	for(i=0; i<n; i++)
	{
		switch(type)
		{
		case GL_BYTE:
			listname = *reinterpret_cast<const char*>(src);
			src++;
			break;

		case GL_UNSIGNED_BYTE:
			listname = *reinterpret_cast<const unsigned char*>(src);
			src++;
			break;

		case GL_SHORT:
			listname = *reinterpret_cast<const short*>(src);
			src+=2;
			break;

		case GL_UNSIGNED_SHORT:
			listname = *reinterpret_cast<const unsigned short*>(src);
			src+=2;
			break;

		case GL_INT:
			listname = *reinterpret_cast<const int*>(src);
			src+=4;
			break;

		case GL_UNSIGNED_INT:
			listname = *reinterpret_cast<const unsigned int*>(src);
			src+=4;
			break;

		case GL_FLOAT:
			listname = (int)(*reinterpret_cast<const float*>(src));
			src+=4;
			break;

		case GL_2_BYTES:
			listname = *reinterpret_cast<const unsigned char*>(src)*256 +
					   *reinterpret_cast<const unsigned char*>(src+1);
			src+=2;
			break;

		case GL_3_BYTES:
			listname = *reinterpret_cast<const unsigned char*>(src)*65536 +
					   *reinterpret_cast<const unsigned char*>(src+1)*256 +
					   *reinterpret_cast<const unsigned char*>(src+1);
			src+=3;
			break;

		case GL_4_BYTES:
			listname = *reinterpret_cast<const unsigned char*>(src)*16777216 +
					   *reinterpret_cast<const unsigned char*>(src+1)*65536 +
					   *reinterpret_cast<const unsigned char*>(src+2)*256 +
					   *reinterpret_cast<const unsigned char*>(src+3);
			src+=4;
			break;
		}

		klDisplayList* dpl = findList(displaylist.listBase+listname);

		if(dpl)
			dpl->execute();
	}
}


void glListBase(GLuint base)
{
	displaylist.listBase = base;
}


GLboolean glIsList(GLuint list)
{
	return findList(list) ? GL_TRUE : GL_FALSE;
}


GLuint glGenLists(GLsizei range)
{
	GLuint ret = displaylist.listIdx;

	displaylist.listIdx += range;
	return ret;
}


void glDeleteLists(GLuint list, GLsizei range)
{
	for(unsigned int listname=list; listname<list+range; listname++)
	{
		klDisplayList* dpl = findList(listname);

		if(dpl)
		{
			displaylist.nameHashTable[listname&(DISPLAYLIST_MAXHASH-1)].removeItem(dpl);
			displaylist.lists.removeItem(dpl);
			delete dpl;
		}
	}
}


/**
}  // class klContext
*/
