/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglArray.h,v 1.1.1.1 2003/12/10 17:07:28 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/

//
// This file holds all opengl functions that deal with
//
//                  vertex arrays
//

void glEnableClientState(GLenum nState)
{
	switch(nState)
	{
	case GL_VERTEX_ARRAY:
		arrayVertex.enabled = true;
		break;

	case GL_NORMAL_ARRAY:
		arrayNormal.enabled = true;
		break;

	case GL_COLOR_ARRAY:
		arrayColor.enabled = true;
		break;

	case GL_TEXTURE_COORD_ARRAY:
		arrayTexCoord.enabled = true;
		break;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glEnableClientState(): unsupported parameter (%d)", nState);
		break;
	}
}


void glDisableClientState(GLenum nState)
{
	switch(nState)
	{
	case GL_VERTEX_ARRAY:
		arrayVertex.enabled = false;
		break;

	case GL_NORMAL_ARRAY:
		arrayNormal.enabled = false;
		break;

	case GL_COLOR_ARRAY:
		arrayColor.enabled = false;
		break;

	case GL_TEXTURE_COORD_ARRAY:
		arrayTexCoord.enabled = false;
		break;

	default:
		//report(reportMode, reportSelector, KL_REPORT_IMPORTANT, "glDisableClientState(): unsupported parameter (%d)", nState);
		break;
	}

	//arrayCachedDirty = true;
}


void glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	arrayColor.set(size, type, stride, pointer);
}


void glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer)
{
	arrayNormal.set(3, type, stride, pointer);
}


void glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	arrayTexCoord.set(size, type, stride, pointer);
}


void glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
	arrayVertex.set(size, type, stride, pointer);
}


void glDrawElements(GLenum polymode, GLsizei count, GLenum datatype, const GLvoid *indices)
{
	if(!arrayVertex.enabled || !arrayVertex.clientData)
		return;

	renderArray(polymode, count, datatype, indices);
}


/**
}  // class klContext
*/
