/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_kl.h,v 1.5 2004/01/28 10:28:47 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// Klimt (non-OpenGL) specific interface
//

void klSetBufferSize(int nWidth, int nHeight)
{
	rasterizer->setSize(nWidth,nHeight);
}


void klSetColorBuffer(void* nMem)
{
	rasterizer->setColorBuffer(nMem);
}


void* klGetColorBuffer()
{
	return rasterizer->getColorBuffer();
}


void klTweak(GLenum nSelect, GLboolean nEnable)
{
	bool enabled = (nEnable==GL_TRUE);

	switch(nSelect)
	{
	case KL_TEXTUREMATRIX:
		tweak.textureMatrixEnabled = enabled;
		break;

	case KL_SPECULARLIGHTING:
		tweak.doSpecularLighting = enabled;
		break;

	case KL_ENABLE_NORMALIZATION:
		tweak.allowNormalization = enabled;
		if(!enabled)
			normalizeNormalsEnabled = false;
		break;

	case KL_FORCE_FLATSHADING:
		tweak.forceFlatShading = enabled;
		if(enabled)
			smoothShadingEnabled = false;

	case KL_FORCE_CULLING:
		tweak.forceCulling = enabled;
		if(enabled)
			cullingEnabled = true;

	}
}


void klPrepareVertexArrays(int nNumVertices, int nNumNormals, int nNumColors, int /*nNumTexCoords*/,
							void* nVertices, void* nColors, void* /*(nTexCoords)*/)
{
	int i;

	checkModelProjMatrix();


	// transform vertices
	//
	klArrayFetcher positionFetcher(arrayVertex);
	klVec4 pos, *dstVertices = reinterpret_cast<klVec4*>(nVertices);

	for(i=0; i<nNumVertices; i++)
	{
		positionFetcher.getVec4(pos, i);

		dstVertices->transform(modelProjMatrix, pos);
		dstVertices++;
	}

	if(nNumNormals)
	{
		klArrayFetcher normalFetcher(arrayNormal);
		klVec3 tnormal, normal, *dstColors = reinterpret_cast<klVec3*>(nColors);
		klVertex vertex;

		for(i=0; i<nNumNormals; i++)
		{
			normalFetcher.getVec3(normal, i);

			tnormal.transform(modelProjMatrixInvTrans, normal);
			calculateVertexLighting(vertex, tnormal, true);

			*(dstColors++) = vertex.col;
			/*(*dstColors)[0] = vertex.col[0];
			(*dstColors)[1] = vertex.col[1];
			(*dstColors)[2] = vertex.col[2];
			dstColors++;*/
		}
	}
	else
	{
		klArrayFetcher colorFetcher(arrayColor);
		klVec3 *dstColors = reinterpret_cast<klVec3*>(nColors);

		for(i=0; i<nNumColors; i++)
		{
			colorFetcher.getVec3(*dstColors, i);
			dstColors++;
		}
	}
}


void
klRenderPreparedIndexedArray(GLenum nPrimType, GLsizei nCount,
							  const unsigned int* nVertexIndices, const unsigned int* nColorIndices, const unsigned int* /*nTexCoordsIndices*/,
							  const void* nVertices, const void* nColors, const void* nTexCoords)
{
	configureRasterizer();

	for(int i=0; i<nCount; i++)
	{
		const klVec3& col3 = reinterpret_cast<const klColor3*>(nColors)[nColorIndices[i]];

		tmpVertices[i].pos = reinterpret_cast<const klVec4*>(nVertices)[nVertexIndices[i]];
		tmpVertices[i].col[0] = col3[0];
		tmpVertices[i].col[1] = col3[1];
		tmpVertices[i].col[2] = col3[2];
		tmpVertices[i].col[3].setInt(1);
	}

	renderPrimitive(nPrimType, tmpVertices, nCount);
}


klRasterizer*
getRasterizer()
{
	return rasterizer;
}


/**
}  // class klContext
*/
