/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_Init.h,v 1.5 2004/02/06 14:14:53 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


// Set default values for the context.
//
klContext(klRasterizer* nRasterizer) : rasterizer(nRasterizer)
{
	// setup indices for materials and lights
	//
	materialFront.idx = 0;
	materialBack.idx = 1;
	for(int i=0; i<MAX_LIGHTS; i++)
		lights[i].idx = i;


	// init matrix stacks
	//
	modelviewStack.init(MAX_MODELVIEW_STACK);
	projectionStack.init(MAX_PROJECTION_STACK);
	textureStack.init(MAX_TEXTURE_STACK);
	curStack = &modelviewStack;						// set modelview as current matrix mode
	modelProjMatrixDirty = true;

	modelviewStack.getTop().makeIdent();
	projectionStack.getTop().makeIdent();
	textureStack.getTop().makeIdent();


	// attribute stacks
	//
	attributeStack.init(MAX_ATTRIBUTE_STACK);
	clientAttributeStack.init(MAX_CLIENTATTRIBUTE_STACK);


	// set initial settings
	//
	lightingEnabled = false;
	cullingEnabled = false;
	texturingEnabled = false;
	blend.enabled = false;
	depthWriteEnabled = true;
	depthTestEnabled = true;
	smoothShadingEnabled = true;
	colorMaterialEnabled = false;
	normalizeNormalsEnabled = false;

	scissor.enabled = false;

	blend.src = GL_ONE;
	blend.dst = GL_ZERO;
	depthFunc = RASTER_ZTEST_LESS;
	//colorMaskRed = colorMaskGreen = colorMaskBlue = GL_TRUE;
	colorMask = COLOR_MASK_RGB;
	textureApplyMode = GL_MODULATE;
	cullMode = GL_BACK;
	frontPolyMode = backPolyMode = GL_FILL;
	frontFace = GL_CCW;


	// initial tweak settings
	//
	tweak.textureMatrixEnabled = true;
	tweak.doSpecularLighting = false;		// in fact this is WRONG, due to the specs this should on switched on,
											// but specular lighting does not work correclty at the moment anyhow...
	tweak.allowNormalization = true;
	tweak.forceFlatShading = false;			// if true, ALWAYS flat shading will be used, independently 
											// of what the application defines by using glShadeModel
	tweak.forceCulling = false;


	// light zero has special default values
	//
	lights[0].diffuse.setInt(1,1,1,1);
	lights[0].specular.setInt(1,1,1,1);
	largestActiveLightIdx = -1;				// all lights are disabled...


	// init some display lists stuff
	//
	displaylist.executeCommands = true;
	displaylist.recording = NULL;
	displaylist.listBase = 0;
	displaylist.listIdx = 0;


	clearDepth = 1.0f;


	// initialize the lighting cache
	//
	lightingCache.updateModelAmbient(materialFront, lightModel);
	lightingCache.updateModelAmbient(materialBack, lightModel);
	lightingCache.updateLightAmbient(materialFront, lights);
	lightingCache.updateLightAmbient(materialBack, lights);
	lightingCache.updateLightDiffuse(materialFront, lights);
	lightingCache.updateLightDiffuse(materialBack, lights);
	lightingCache.updateLightSpecular(materialFront, lights);
	lightingCache.updateLightSpecular(materialBack, lights);

	
	/*int listname = glGenLists(1);
	glNewList(listname, GL_COMPILE);
		glBegin(GL_TRIANGLES);
		glColor3f(1.0f, 1.0f, 0.0f);
		glVertex3f(-0.5f, 0.5f, 1.0f);
		glVertex3f( 0.5f, 0.5f, 1.0f);
		glVertex3f( 0.0f, 0.0f, 1.0f);
		glEnd();
	glEndList();

	glCallList(listname);
	glDeleteLists(listname, 1);*/
}


~klContext()
{
	delete rasterizer;
}


/**
}  // class klContext
*/
