/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfaceGapi.cpp,v 1.1 2004/01/13 11:20:10 drgoldie Exp $
 *
\**************************************************************************/


#include "klEGLSurfaceGapi.h"
#include "../klBlitter.h"


klEGLSurfaceGapi::klEGLSurfaceGapi()
{
	colorType = COLOR_TYPE_RGB565;
	depthType = DEPTH_TYPE_INT32;

	width = height = 0;
	cBuffer = NULL;
	zBuffer = NULL;

	hwnd = NULL;
	hdc = NULL;
	displayOpened = false;
}


klEGLSurfaceGapi::~klEGLSurfaceGapi()
{
	destroy();
}


bool
klEGLSurfaceGapi::setNativeWindow(NativeWindowType nWnd)
{
	hwnd = nWnd;									// note: we keep this HWND and HDC

	//
	// TODO: also support non fullscreen windows
	//

	// try to call up Gapi
	//
	if(GXOpenDisplay(hwnd, GX_FULLSCREEN) == 0)
		return false;

	// check if we have 16-bits as expected...
	//
	gxDisplayProp = GXGetDisplayProperties();
	if (gxDisplayProp.cBPP != 16)
	{
		// We are only dealing with 16 bit color in this code
		GXCloseDisplay();
		return false;
	}

	setSize(320,240);

	displayOpened = true;
	return true;
}


bool
klEGLSurfaceGapi::setNativeDisplay(NativeDisplayType nDisp)
{
	// this will work as long as there is only one window
	// in this application
	hdc = nDisp;
	hwnd = GetActiveWindow();

	if(hwnd==NULL)
		return false;

	return setNativeWindow(hwnd);
}


NativeWindowType
klEGLSurfaceGapi::getNativeWindow()
{
	return hwnd;
}


NativeDisplayType
klEGLSurfaceGapi::getNativeDisplay()
{
	return hdc;
}


bool
klEGLSurfaceGapi::destroy()
{
	bool ret = true;

	if(cBuffer)
		delete cBuffer;
	cBuffer = NULL;

	if(zBuffer)
		delete zBuffer;
	zBuffer = NULL;

	GXCloseDisplay();

	width = height = 0;
	hwnd = NULL;
	hdc = NULL;

	return ret;
}


void
klEGLSurfaceGapi::setSize(int nWidth, int nHeight)
{
	if(width!=nWidth || height!=nHeight)
	{
		width = nWidth;
		height = nHeight;

		if(cBuffer)
			delete cBuffer;
		cBuffer = new unsigned short[width*height];

		if(zBuffer)
			delete zBuffer;
		zBuffer = new unsigned int[width*height];
	}
}


bool
klEGLSurfaceGapi::flip()
{
	unsigned short* dst = (unsigned short*)GXBeginDraw();
	int				xPitch = gxDisplayProp.cbxPitch / 2,
					yPitch = gxDisplayProp.cbyPitch / 2;

	if(xPitch>0 && yPitch>0)		// 'normal' 240x320 mode
	{
		if(xPitch!=1 || yPitch!=240)
		{
			GXEndDraw();
			return false;					// unsupported memory layout
		}

		// this video layout forces us to blit the screen rotated by 270 degrees
		klBlitter::blit(dst, (unsigned short*)cBuffer, 320,240, klBlitter::ROTATE_270, 240,320, 40,40);
	}
	else
	if(xPitch>0 && yPitch<0)		// 'rotated' 240x320 mode
	{
		if(xPitch!=320 || yPitch!=-1)
		{
			GXEndDraw();
			return false;					// unsupported memory layout
		}

		// this video layout forces us to blit the screen rotated by 0 degrees
		//Blitter::blit(dst-319, backbuffer->getPixels(), 320,240, Blitter::ROTATE_0, 320,240, 40,40);
		memcpy(dst-319, cBuffer, 320*240*2);
	}


	GXEndDraw();
	return true;
}
