/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/RasterizerSW565/klRSW565_InterpolatorInt.h,v 1.2 2004/02/10 18:19:31 drgoldie Exp $
 *
\**************************************************************************/


//
//class klRSW565 {
//

class InterpolatorInt_Linear
{
public:
	typedef int 	DTYPE;

	enum {
		PBITS = 12,
		PFACT = 1<<PBITS,
		ROUNDVAL = PFACT>>1,
	};

	InterpolatorInt_Linear(int nV0, int nV1, int nLength)
	{
		v = (DTYPE)(nV0<<PBITS);

		if(nLength<1)
			return;

		int invLen = (PFACT*PFACT) / (nLength);
		dv = (DTYPE)(((nV1-nV0)*invLen)>>(PBITS));
	}

	InterpolatorInt_Linear(int nV0, int nV1, klFloat nInvLength)
	{
		v = (DTYPE)(nV0<<PBITS);

		int invLen = nInvLength.getFixed() << 8;	// shift 2*4 bits since klFloat uses 16 precision bits instead of 12...

		dv = (DTYPE)(((nV1-nV0)*invLen)>>(PBITS));
	}

	void step()
	{
		v += dv;
	}

	void step(int nSteps)
	{
		v += nSteps*dv;
	}

	DTYPE get()
	{
		return (v+ROUNDVAL)>>PBITS;
	}

protected:
	DTYPE	v,dv;
};

//
// } class klRSW565
//
