
#ifndef ZFONT_H
   #define ZFONT_H

   #include <qimage.h>
   #include <qpixmap.h>
   #include <qstring.h>
   #include <qdirectpainter_qws.h>
   #include <qgfx_qws.h>
   #include <qstring.h>
   #include "ZSurface.h"
   

                                     
//! ZFont a bitmapped font class for drawing text to ZSurfaces.

/*!

ZFont supports two font formats: an image based format ( custom font image) or default QFont based format. 
<br>
When initialized with QImage , this class will used underlying ZSurface (which this class is derived from) as a source of character glyphs.<br>
The QImage based font format is illustrated in the picture below:<P>
<img src=font.png width=320 height=64 frame=2> <P>
Each character will always be drawn as it is presented in the bitmap. 
The white kerning lines above each character adjusts the distance between the character and the surrounding characters in a sentence. 
<br>This is the same format for fonts as used by <a href="http://www.gapidraw.com">GapiDraw </a> game library available for Pocket PC devices.
<br>This library (free) includes Windows based program for creating font images using TTF fonts as a source.
<P>
When initialized with QFont , the object will render all ASCII characters from that font on the underlying ZSurface object and use them as a source
of character glyphs.<br>
<B>Usage:</B><P>
You can prepare an external image with renderings for each character of your font ( this way you can create antialiased fonts etc ..)
or you can simply initialize ZFont with an existing QFont object.<br>
For example to create QT based (helvetica,bold,10 points) font use:<P>
<code> myZFontClass.create(QFont("helvetica",10,QFont::Bold),QColor(255,255,255),QColor(0,0,0));</code>
<P>
After that you can simply call:<P><code> myZSurface.drawText(x,y,QString("text"),&myZFontClass);</code><p>


*/

class ZFont: public ZSurface
{


public:
/*!
 Constructs an invalid (null) ZFont object.
*/ 
   ZFont();
/*! 
Constructs a ZFont out of a valid QImage object.<br>
The backColor value indicates background color value (transparent pixel) used during ZSurface::drawText() methods.  
*/
   ZFont(const QImage &,QColor backColor);
/*! 
Constructs a ZFont out of a valid QPixmap object.<br>
The backColor value indicates background color value (transparent pixel) used during ZSurface::drawText() methods.  
*/
   ZFont(const QPixmap &,QColor backColor);
/*! 
Constructs a ZFont out of a valid QFont object.<br>
The foreColor value indicates the default color that will be associated with this font object.  
*/

   ZFont(const QFont &,QColor foreCol,  QColor backCol);

/*!
Constructs a deep copy of ZFont object.
*/

   ZFont(const ZFont &);
/*! 
Assigns a deep copy of f to this ZFont object and returns a reference to it.
*/ 
   ZFont & operator=(const ZFont &f);

/*! 
Destroys the object and cleans up
*/
   ~ZFont();

/*!
Initializes an existing instance of ZFont object from a valid QImage.
The backColor value indicates background color value (transparent pixel) used during ZSurface::drawText() methods.
Returns false if memory allocation failed or QImage depth is not 32.
*/ 
   bool create(const QImage &, QColor backColor);
/*!
Initializes an existing instance of ZFont object from a valid QPixmap.
The backColor value indicates background color value (transparent pixel) used during ZSurface::drawText() methods.
Returns false if memory allocation failed.
*/ 
   bool create(const QPixmap &,QColor backColor);
/*!
Initializes an existing instance of ZFont object from a valid QFont object.
The foreColor value indicates the default color that will be associated with this font object.
Returns false if memory allocation failed.
*/
   bool create(const QFont &, QColor foreColor, QColor backCol);

/*!
 Returns the width of character c in pixels. 
*/ 
   inline int  charWidth(char c) const
   {
      return iWidth[(int)c-32];
   }
/*!
 Returns offset x of character c in the underlying ZSurface image. 
*/ 
   inline int x(char c) const
   {
      return iOffset[(int)c-32];
   }
/*
   inline void setHeight(int h)
   {
      iHeight=h;
   }
*/   
/*!
 Returns height of the font excluding white kerning line. 
*/
 
   inline int height() const
   {
      return iHeight;
   }
/*!
 Returns offset y of the ZFont object in the underlying ZSurface image. 
*/
   inline int y() const
   {
      return skipTop;
   }
/*!
 Sets spacing in pixels to be used when drawing letters. 
*/

   inline void setSpacing(int s)
   {
      iSpacing=s;
   }
/*!
 Returns current value of spacing between letters. 
*/

   inline int spacing() const
   {
      return iSpacing;
   }

/*!
 Returns the width of string (distance where the next string should be drawn). 
*/ 
   int   stringWidth(const QString &s) const;


/*!
 Returns the background color for this ZFont object ( this value will be used to indicate transparent pixels when drawing text on ZSurface.) 
*/ 
   QColor backgroundColor() const
   {
      return iBackColor;
   }

private:

   void initGeneric();
   void initFromCustomImage(QColor c);
   bool initFromCustomFont(const QFont &f, QColor fc, QColor bc);

   void copyFont(const ZFont &);

   int   iOffset[256-32];        // offset of each letter
   int   iWidth[256-32];         // width of each letter
   int   iHeight;             // total height of the font

   int   skipTop;             // how  many pixels to skip from top
   int   iSpacing;
   QColor iBackColor;

};                    

#endif // INPUT_DIALOG_H

