/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@ims.tuwien.ac.at>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfaceQTE.h,v 1.2 2004/01/14 10:01:50 drgoldie Exp $
 *
 *  This code was contributed by Ryan Rusaw of Cacko (cacko.biz)
 *
\**************************************************************************/


#ifndef __KLEGLSURFACE_QTE_HEADERFILE__
#define __KLEGLSURFACE_QTE_HEADERFILE__


#include "klEGLSurface.h"
#include <qpainter.h>
#include "ZSurface.h"

/// QT Embedded implementation of EGLSurface using ZSurface

class klEGLSurfaceQTE : public klEGLSurface
{
public:
	klEGLSurfaceQTE();
	~klEGLSurfaceQTE();

	virtual bool setNativeWindow(NativeWindowType nHWnd);
	virtual bool setNativeDisplay(NativeDisplayType nDisp);

	virtual NativeWindowType getNativeWindow();
	virtual NativeDisplayType getNativeDisplay();

	virtual bool destroy();
	virtual bool flip();

private:
	void setSize(int nWidth, int nHeight);
	NativeWindowType	hwnd;		// QWidget *
	NativeDisplayType	hdc;		// void *
	bool				displayOpened;
	ZSurface*			backBuffer;
};


#endif //__KLEGLSURFACE_QTE_HEADERFILE__
