/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@ims.tuwien.ac.at>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfaceQTE.cpp,v 1.2 2004/01/14 10:01:50 drgoldie Exp $
 *
 *  This code was contributed by Ryan Rusaw of Cacko (cacko.biz)
 *
\**************************************************************************/

#include "klEGLSurfaceQTE.h"
#include "klBlitter.h"

#include <qapplication.h>
#include <qsize.h>
#include "ZSurface.h"

klEGLSurfaceQTE::klEGLSurfaceQTE()
{
	colorType = COLOR_TYPE_RGB565;
	depthType = DEPTH_TYPE_INT32;

	width = height = 0;

	cBuffer = NULL;
	zBuffer = NULL;
	backBuffer = NULL;

	hwnd = NULL;
	hdc = NULL;
	displayOpened = false;
}

klEGLSurfaceQTE::~klEGLSurfaceQTE()
{
	destroy();
}

bool
klEGLSurfaceQTE::setNativeWindow(NativeWindowType nHWnd)
{
	hwnd = nHWnd;

	setSize(QApplication::desktop()->height(),QApplication::desktop()->width());
	displayOpened = true;
	
	return true;
}


bool
klEGLSurfaceQTE::setNativeDisplay(NativeDisplayType nDisp)
{
	hdc = nDisp;

	if (backBuffer==NULL)
		return false;
	
	return true;
}


NativeWindowType
klEGLSurfaceQTE::getNativeWindow()
{
	return hwnd;
}


NativeDisplayType
klEGLSurfaceQTE::getNativeDisplay()
{
	return hdc;
}


bool
klEGLSurfaceQTE::destroy()
{
	bool ret = true;

	cBuffer = NULL;

	if(backBuffer)
		delete backBuffer;
	backBuffer = NULL;

	if(zBuffer)
		delete zBuffer;
	zBuffer = NULL;

	width = height = 0;

	hwnd = NULL;
	hdc = NULL;

	return ret;
}

void
klEGLSurfaceQTE::setSize(int nWidth, int nHeight)
{

	if(width!=nWidth || height!=nHeight)
	{
		width = nWidth;
		height = nHeight;

		if(backBuffer)
			backBuffer->create(width,height);
		else
			backBuffer = new ZSurface(width,height);

		cBuffer = backBuffer->bits();

		if(zBuffer)
			delete zBuffer;
		zBuffer = new unsigned int[width*height];
	}
}


bool
klEGLSurfaceQTE::flip()
{
	int		xPitch = hwnd->width(),
			yPitch = hwnd->height();

	if(xPitch > yPitch)		//  320x240 mode
	{
		if(xPitch!=320 || yPitch!=240)
		{
			return false;					// unsupported memory layout
		}
		// this video layout forces us to blit the screen rotated by 270 degrees

		// Create a QDirectPainter so we can get the framebuffer address from it
		QDirectPainter dst(hwnd);
		// use the assembly routines from zsurface.a
#ifdef USE_C
   		// we have to fool qvfb to update entire screen
   		dst.fillRect(0,0,320,240, QColor(0,0,0));
		memcpy(dst.frameBuffer(), cBuffer, 320*240*2);
#else
		ZSurface::bitBlit(&dst,backBuffer,ZSurface::Z0);
#endif // USE_C
	}
	else
	if(xPitch < yPitch)		// 240x320 mode
	{
		if(xPitch!=240 || yPitch!=320)
		{
			return false;					// unsupported memory layout
		}
		// this video layout forces us to blit the screen rotated by 0 degrees

		// Create a QDirectPainter so we can get the framebuffer address from it
		QDirectPainter dst(hwnd);
		// use the assembly routines from zsurface.a
#ifdef USE_C
   		// we have to fool qvfb to update entire screen
   		dst.fillRect(0,0,240,320, QColor(0,0,0));
		memcpy(dst.frameBuffer(), cBuffer, 320*240*2);
#else
		ZSurface::bitBlit(&dst,backBuffer,ZSurface::Z270);
#endif // USE_C
	}
	return true;
}