/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@ims.tuwien.ac.at>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id:
 *
 *  This code was contributed by 
 *  Bruno Barberi Gnecco <brunobg@users.sourceforge.net>
 *
\**************************************************************************/


#include "klEGLSurfacePTC.h"
#include "../klBlitter.h"
#include <string.h>
#include <iostream>

klEGLSurfacePTC::klEGLSurfacePTC()
{
	/* TinyPTC originally uses RGB888, but the RGB888 rasterizer is not
	working yet. Two possibilities: 
	- convert from 565 to 888. PTC will reconvert it to whatever mode your
	  video is. This should work in any platform.
	- don't convert to 888, but use a hacked PTC that uses 565. This may
	  not work well in your platform, but it's highly likely that a 
	  16 bit screen will be 565. Pray that it's RGB565 and not BGR565,
	  otherwise you'll have to invert the bits.
	*/
	colorType = COLOR_TYPE_RGB565;
	depthType = DEPTH_TYPE_INT32;

	width = height = 0;
	cBuffer = NULL;
	zBuffer = NULL;

	displayOpened = false;
}


klEGLSurfacePTC::~klEGLSurfacePTC()
{
//	ptc_close();
	destroy();
}


bool
klEGLSurfacePTC::setNativeWindow(NativeWindowType nWnd)
{
	setSize(300, 300);
	if (!ptc_open ("test", 300, 300)) {
		return false;
	}

	displayOpened = true;
	return true;
}


bool
klEGLSurfacePTC::setNativeDisplay(NativeDisplayType nDisp)
{
	return true;
}


bool
klEGLSurfacePTC::destroy()
{
	bool ret = true;

	if(cBuffer)
		delete static_cast<unsigned short *>(cBuffer);
	cBuffer = NULL;

	if(zBuffer)
		delete static_cast<unsigned int *>(zBuffer);
	zBuffer = NULL;

#ifndef HACK_RGB565
	if(buf)
		delete static_cast<unsigned int *>(buf);
	buf = NULL;
#endif

	width = height = 0;

	return ret;
}


void
klEGLSurfacePTC::setSize(int nWidth, int nHeight)
{
	if(width!=nWidth || height!=nHeight)
	{
		width = nWidth;
		height = nHeight;

		if(cBuffer)
			delete static_cast<unsigned short *>(cBuffer);
		cBuffer = new unsigned short[width*height];

		if(zBuffer)
			delete static_cast<unsigned int *>(zBuffer);
		zBuffer = new unsigned int[width*height];

#ifndef HACK_RGB565
		if(buf)
			delete static_cast<unsigned int *>(zBuffer);
		buf = new unsigned int[width*height];
#endif
	}
}


bool
klEGLSurfacePTC::flip()
{
#ifndef HACK_RGB565
	unsigned short *cb = static_cast<unsigned short *>(cBuffer);

	for (int i = 0; i < width*height; i++) {
		buf[i] = ((cb[i] & 0x1F) << 3) |
			((cb[i] & 0x7E0) << (8-5)+2) |
			((cb[i] & 0xF800) << (16-11)+3);
	}
	ptc_update(buf);
#else
	ptc_update(cBuffer);
#endif
	return true;
}

NativeWindowType
klEGLSurfacePTC::getNativeWindow()
{
	return NULL;
}


NativeDisplayType
klEGLSurfacePTC::getNativeDisplay()
{
	return 0;
}
