/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klChunkedMemory.h,v 1.2 2004/01/13 15:40:57 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLCHUNKEDMEMORY_HEADERFILE__
#define __KLCHUNKEDMEMORY_HEADERFILE__


#include "klList.h"
#include "klPtrList.h"


/// Allocates blocks memory in large chunks
/**
 *  The memory blocks can lateron be
 *  requested sequentially.
 */
class klChunkedMemory
{
public:
	friend class klChunkedMemoryIterator;


	klChunkedMemory(int nChunkSize);

	void* getNewMemory(int nSize);

	void* getFirstBlock();

	void cleanup();


protected:
	klPtrList<unsigned char>	chunks;
	klList<int>					chunkSizes;
	int							chunkSizeMax;
};


class klChunkedMemoryIterator
{
public:
	klChunkedMemoryIterator(const klChunkedMemory& nChunkedMemory) : chunks(nChunkedMemory.chunks), chunkSizes(nChunkedMemory.chunkSizes)
	{
		curChunk = curChunkOffset = 0;
	}

	klChunkedMemoryIterator(const klChunkedMemoryIterator& nOther) : chunks(nOther.chunks), chunkSizes(nOther.chunkSizes)
	{
		curChunk = nOther.curChunk;
	}

	void next(int nSize)
	{
		int curChunkSize = chunkSizes[curChunk];

		curChunkOffset += nSize;
		if(curChunkOffset>=curChunkSize)
		{
			curChunk++;
			curChunkOffset = 0;
		}
	}

	const void* getBlock() const
	{
		return chunks[curChunk] + curChunkOffset;
	}

	bool hasMoreBlocks() const
	{
		return curChunk<chunks.getSize() && curChunkOffset<chunkSizes[curChunk];
	}


protected:
	klChunkedMemoryIterator& operator=(const klChunkedMemoryIterator&)
		{	return *this;	}

	int								curChunk, curChunkOffset;
	const klPtrList<unsigned char>&	chunks;
	const klList<int>&				chunkSizes;
};


#endif //__KLCHUNKEDMEMORY_HEADERFILE__
