/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klBitField.h,v 1.1.1.1 2003/12/10 17:07:29 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLBITFIELD_HEADERFILE__
#define __KLBITFIELD_HEADERFILE__


// A simple bitfield container
// 
// Bitfields store boolean values with one bit per value.
// Due to the low memory footprint a good cache usage is achieved.
//
class klBitField
{
public:
	klBitField()  {  data = 0;  }

	inline void init(int nSize);

	inline void clearAll()  {  memset(data, 0, size);  }

	bool isSet(int nIdx)  {  return (data[nIdx>>5] & (1<<(nIdx&0x1f)))!=0;  }

	void set(int nIdx)  {  data[nIdx>>5] |= (1<<(nIdx&0x1f));  }

	void clear(int nIdx)  {  data[nIdx>>5] &= ~(1<<(nIdx&0x1f));  }

protected:
	unsigned int	*data;
	int				size;
};


inline void
klBitField::init(int nSize)
{
	size = (nSize>>5) + (nSize&0x1f ? 1 : 0);

	if(data)
		delete data;
	data = new unsigned int[size];

	clearAll();
}


#endif //__KLBITFIELD_HEADERFILE__
