/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klBase.h,v 1.1.1.1 2003/12/10 17:07:29 drgoldie Exp $
 *
\**************************************************************************/


#ifndef NULL
#define NULL 0
#endif


// returns the number of bytes a specific
// opengl data type occupies
inline int getByteSizeFromDataType(GLenum nType)
{
	switch(nType)
	{
	case GL_UNSIGNED_BYTE:
	case GL_BYTE:
		return 1;

	case GL_UNSIGNED_SHORT:
	case GL_SHORT:
		return 2;

	case GL_UNSIGNED_INT:
	case GL_INT:
	case GL_FLOAT:
	case GL_FIXED:
		return 4;

	case GL_DOUBLE:
		return 8;
	}

	return 0;
}


// returns the number of vertices one
// primitive of a specific type has
inline int getPrimitiveLength(GLenum nPrimType, int nNum)
{
	switch(nPrimType)
	{
	case GL_POINTS:
		return 1;
	case GL_LINES:
		return 2;
	case GL_TRIANGLES:
		return 3;
	case GL_QUADS:
		return 4;
	case GL_LINE_LOOP:
	case GL_LINE_STRIP:
	case GL_TRIANGLE_FAN:
	case GL_TRIANGLE_STRIP:
	case GL_QUAD_STRIP:
	case GL_POLYGON:
		return nNum;
	}
	return -1;
}


// returns the indexed value in the passed array
// if the array pointer is NULL the index itself is returned
inline int getIndex(GLenum nIndexType, int nIndex, const GLvoid* nIndices)
{
	if(!nIndices)
		return nIndex;

	switch(nIndexType)
	{
	case GL_UNSIGNED_BYTE:
		return reinterpret_cast<const unsigned char*>(nIndices)[nIndex];

	case GL_UNSIGNED_SHORT:
		return reinterpret_cast<const unsigned short*>(nIndices)[nIndex];

	case GL_UNSIGNED_INT:
		return reinterpret_cast<const unsigned int*>(nIndices)[nIndex];
	}

	return 0;
}


inline int getNumRGBComponents(int nFormat)
{
	switch(nFormat)
	{
	case 1:
	case 2:
	case 3:
	case 4:
		return nFormat;

	//case GL_ALPHA8:
	//case GL_LUMINANCE8:
	//case GL_INTENSITY8:
	//	return 1;

	//case GL_RGB16:
	//	return 2;

	case GL_RGB:
		return 3;

	case GL_RGBA:
		return 4;

	default:
		return 0;
	}
}
