/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klMain.h,v 1.3 2004/02/06 14:14:53 drgoldie Exp $
 *
\**************************************************************************/



#ifndef __KLMAIN_HEADERFILE__
#define __KLMAIN_HEADERFILE__

#ifdef _WIN32_WCE
    // definitions for windows ce
    #define _IS_WINDOWS_
    #define _IS_WINCE_
#else
  #ifdef WIN32
    // definitions for desktop windows
    #define _IS_WINDOWS_
    #define _IS_WIN32_
  #endif //WIN32
#endif //_WIN32_WCE

#ifdef _LINUX
  #ifdef QWS
    // definitions for embedded linux (zaurus)
    #define _IS_LINUX_
    #define _IS_QTEMBEDDED_
  #else
    // definitions for desktop linux (X11 with SDL)
    #define _IS_LINUX_
    #define _IS_SDL_
  #endif
#endif //_LINUX


// define KLIMT_NODLL if you want to
// link statically instead of using a DLL
//
#ifdef _IS_WINDOWS_
  #pragma warning (disable: 4514 4100)

  #ifdef KLIMT_NODLL
    #define KLIMT_API
  #else //!KLIMT_NODLL
    #ifdef KLIMT_EXPORTS
      #define KLIMT_API __declspec(dllexport)
    #else //KLIMT_EXPORTS
      #define KLIMT_API __declspec(dllimport)
    #endif //KLIMT_EXPORTS
  #endif //KLIMT_NODLL
  #else
    #define KLIMT_API

  #define GLAPIENTRY KLIMT_API
#endif // _IS_WINDOWS_

#ifndef NULL
  #define NULL 0L
#endif

#endif //__KLMAIN_HEADERFILE__
