/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_STANDARDHEADER_JUCEHEADER__
#define __JUCE_STANDARDHEADER_JUCEHEADER__

//==============================================================================
/** Current Juce version number.

    See also SystemStats::getJUCEVersion() for a string version.
*/
#define JUCE_MAJOR_VERSION      1
#define JUCE_MINOR_VERSION      29

/** Current Juce version number.

    Bits 16 to 32 = major version.
    Bits 8 to 16 = minor version.
    Bits 0 to 8 = point release (not currently used).

    See also SystemStats::getJUCEVersion() for a string version.
*/
#define JUCE_VERSION            ((JUCE_MAJOR_VERSION << 16) + (JUCE_MINOR_VERSION << 8))


//==============================================================================
#include "../../../juce_Config.h"

#ifdef _MSC_VER
  #pragma warning (push)
  #pragma warning (disable: 4514 4245 4100)
#endif

#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <limits.h>
#include <math.h>
#include <ctype.h>
#include <stdexcept>
#ifndef _WIN32
  #include <pthread.h>
#endif

#ifdef _MSC_VER
  #pragma warning (pop)
#endif

//==============================================================================
#ifdef JUCE_NAMESPACE
  #define BEGIN_JUCE_NAMESPACE    namespace JUCE_NAMESPACE {
  #define END_JUCE_NAMESPACE      }
#else
  #define BEGIN_JUCE_NAMESPACE
  #define END_JUCE_NAMESPACE
#endif

//==============================================================================
#ifdef JUCE_WIN32
  #ifdef JUCE_DLL_BUILD
    #define JUCE_API __declspec (dllexport)
  #elif defined (JUCE_DLL)
    #define JUCE_API __declspec (dllimport)
  #endif
#endif

#ifndef JUCE_API
  #define JUCE_API
#endif

//==============================================================================
#include "juce_PlatformDefs.h"
#include "juce_Memory.h"
#include "juce_MathsFunctions.h"
#include "juce_DataConversions.h"
#include "juce_Atomic.h"
#include "../text/juce_TextFunctions.h"


#endif   // __JUCE_STANDARDHEADER_JUCEHEADER__
