/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "juce_StandardHeader.h"

BEGIN_JUCE_NAMESPACE


#include "juce_Random.h"


//==============================================================================
Random::Random (const int64 seedValue) throw()
    : seed (seedValue)
{
}

Random::~Random() throw()
{
}

void Random::setSeed (const int64 newSeed) throw()
{
    seed = newSeed;
}

//==============================================================================
int Random::nextInt() throw()
{
#ifndef __GNUC__
    seed = (seed * 0x5deece66d + 11) & 0xffffffffffff;
#else
    seed = (seed * 0x5deece66dLL + 11) & 0xffffffffffffLL;
#endif

    return (int)(seed >> 16);
}

int Random::nextInt (const int maxValue) throw()
{
    return (nextInt() & 0x7fffffff) % maxValue;
}

bool Random::nextBool() throw()
{
    return (nextInt() & 1) != 0;
}

float Random::nextFloat() throw()
{
    return (nextInt() & 0x7fffffff) / (float) 0x7fffffff;
}

double Random::nextDouble() throw()
{
    return (nextInt() & 0x7fffffff) / (double) 0x7fffffff;
}

//==============================================================================
static Random sysRand (1);

Random& Random::getSystemRandom() throw()
{
    return sysRand;
}

END_JUCE_NAMESPACE
