/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#include "hfiles.h"
#include "headers.h"
#include "mysqlMeta.h"
#include "ttypes.h"

// Get OLE DB data type from wide char
DBTYPE GetOledbTypeFromName(LPOLESTR wszName, BOOL* pbIsMySqlBlob = NULL ); 


#include "cache_loadmeta.h"

#define		RESERVED_SWST_TYPE_MARGIN		200


CSwstMeta::CSwstMeta()
{
	CLEAR_CONSTRUCT( CSwstMeta );
}

CSwstMeta::CSwstMeta(const CSwstMeta& cpy) 
{ 
	CLEAR_CONSTRUCT( CSwstMeta ); 
	*this=cpy; 
}

void CSwstMeta::Destroy()
{
	if (m_pFiles != NULL)
	{
		// Free fields associated with every file
		for (MT_SINT i = 0; i < m_siFiles; i++)
		{
			free(m_pFiles[i].m_pFields);
			free(m_pFiles[i].m_pIndexes);
		}

		free( m_pFiles );
	}

	if( m_pRelations != NULL )
	{
		// Free segments of parent and dependent indexes for every relation
		for (MT_SINT i = 0; i < m_siRelations; i++)
		{
			free(m_pRelations[i].m_ppParentIndex);
			free(m_pRelations[i].m_ppDependIndex);
		}

		free( m_pRelations );
	}
	
	free( m_pFields );
	free( m_pIndexes );

	release();
}



CSwstMeta::~CSwstMeta()
{
	CSwstMeta::Destroy();
}

/////
void CSwstMeta::release() {
    if(m_pTempODBC) m_pTempODBC->Release();
    m_pTempODBC=0;
}

//copy operation
CSwstMeta& CSwstMeta::operator=(const CSwstMeta& cpy)
{
    int i,j;

    //copy fields and indexes
    m_siFields = cpy.m_siFields;
	if( m_siFields )
	{
		m_pFields = (SWSTFIELD*)malloc( sizeof(SWSTFIELD) * m_siFields );
		memcpy( m_pFields, cpy.m_pFields, sizeof(SWSTFIELD) * m_siFields ); 
	}
	else
		m_pFields = NULL;

    m_siIndexes = cpy.m_siIndexes;
	if( m_siIndexes )
	{
		m_pIndexes = (SWSTINDEX*)malloc( sizeof(SWSTINDEX) * m_siIndexes );
		memcpy( m_pIndexes, cpy.m_pIndexes, sizeof(SWSTINDEX) * m_siIndexes ); 
	}
	else
		m_pIndexes = NULL;


    m_siRelations = cpy.m_siRelations;
	if( m_siRelations )
	{
		m_pRelations = (SWSTRELATE*)malloc( sizeof(SWSTRELATE) * m_siRelations );
		memcpy( m_pRelations, cpy.m_pRelations, sizeof(SWSTRELATE) * m_siRelations ); 
	}
	else
		m_pRelations = NULL;


    //copy files
    m_siFiles = cpy.m_siFiles;
    if( cpy.m_pFiles != 0 ) {
        m_pFiles = (SWSTFILE*)malloc( m_siFiles * sizeof(SWSTFILE) );
        memcpy( m_pFiles, cpy.m_pFiles, m_siFiles * sizeof(SWSTFILE) );

		for (i = 0; i < m_siFiles; i++)
		{
            m_pFiles[i].m_pFields = (SWSTFIELD**)malloc( sizeof(SWSTFIELD*) * m_pFiles[i].m_wFields );
            //correct cross links: file to fields
            for (j = 0; j < m_pFiles[i].m_wFields; j++) {
                m_pFiles[i].m_pFields[j] = m_pFields + (cpy.m_pFiles[i].m_pFields[j] - cpy.m_pFields);
            }

            m_pFiles[i].m_pIndexes = (SWSTINDEX**)malloc( sizeof(SWSTINDEX*) * m_pFiles[i].m_wIndexes );
            //correct cross links: file to indexes
            for (j = 0; j < m_pFiles[i].m_wIndexes; j++) {
                m_pFiles[i].m_pIndexes[j] = m_pIndexes + (cpy.m_pFiles[i].m_pIndexes[j] - cpy.m_pIndexes);
            }

            //correct cross links: file to CatalogOwner
            m_pFiles[i].m_pCatalogOwner = &m_CatalogOwner;
		}
    } else {
        m_pFiles = 0;
    }

    //correct cross links: field to file
    for( i = 0; i < m_siFields; i++ ) {
        m_pFields[i].m_pSwstFile = m_pFiles + (cpy.m_pFields[i].m_pSwstFile - cpy.m_pFiles);
    }

    //correct cross links: index to field, index to fieldName, index to relate 
    for( i = 0; i < m_siIndexes; i++ ) {
        m_pIndexes[i].m_pSwstField = m_pFields + (cpy.m_pIndexes[i].m_pSwstField - cpy.m_pFields);
        m_pIndexes[i].m_pSwstFieldName = m_pFields + (cpy.m_pIndexes[i].m_pSwstFieldName - cpy.m_pFields);
        m_pIndexes[i].m_pSwstRelateName = m_pRelations + (cpy.m_pIndexes[i].m_pSwstRelateName - cpy.m_pRelations);
    }

    for( i = 0; i < m_siRelations; i++ ) {
        //correct cross links: relate to indexes
        for( j = 0; j < m_pRelations[i].m_wParentIndexes; j++ ) {
            m_pRelations[i].m_ppParentIndex[j] = m_pIndexes + (cpy.m_pRelations[i].m_ppParentIndex[j] - cpy.m_pIndexes);
        }
        for( j = 0; j < m_pRelations[i].m_wDependIndexes; j++ ) {
            m_pRelations[i].m_ppDependIndex[j] = m_pIndexes + (cpy.m_pRelations[i].m_ppDependIndex[j] - cpy.m_pIndexes);
        }
    }

    memcpy( m_szDdfPath, cpy.m_szDdfPath, sizeof(m_szDdfPath) );
    memcpy( m_szDataPath, cpy.m_szDataPath, sizeof(m_szDataPath) );
    
    memcpy( m_szTempODBC, cpy.m_szTempODBC, sizeof(m_szTempODBC) );
    memcpy( m_szServerName, cpy.m_szServerName, sizeof(m_szServerName) );

	memcpy( m_szMySqlStr, cpy.m_szMySqlStr, sizeof(m_szMySqlStr) );

    m_iDriverID = cpy.m_iDriverID;
    memcpy( m_szUser, cpy.m_szUser, sizeof(m_szUser) );
    memcpy( m_szPassword, cpy.m_szPassword, sizeof(m_szPassword) );
    m_CatalogOwner = cpy.m_CatalogOwner;
    //m_cRef = cpy.m_cRef; //???
    m_fltVersion = cpy.m_fltVersion;

    m_pTempODBC = cpy.m_pTempODBC;
    if(m_pTempODBC) m_pTempODBC->AddRef();

    return *this;
}

HRESULT LoadRows(LPCSTR pszPath, LPCSTR pszFile, MT_WORD wRowSize, MT_WORD usiKey, MT_LONG* psiRows, void** ppRows)
{
	HRESULT hr = S_OK;
	return hr;
}


// Care about names with spaces!
inline void TrimRight(LPSTR sz, int len)
{
	for (LPSTR pch = sz + len - 1; pch >= sz; pch--)
		if (*pch == ' ')
			*pch = '\0';
		else
			return;
}

//Loads data from file.ddf and field.ddf
HRESULT CSwstMeta::LoadMetaData_Slow(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, LPCOLESTR lpwszOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverID, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr )
{
	HRESULT hr;
	
	SWSTFILE*  pFile;
	SWSTFIELD* pField;
	SWSTINDEX* pIndex;
	SWSTRELATE* pRelate;
	
	SWSTFIELD** ppLiskField;
	SWSTINDEX** ppLinkIndex;
	
	MT_LONG iFile;
	MT_LONG iField;
	MT_LONG iIndex;
	MT_LONG iRelate;

	if( typeOfDataSource == DATASOURCE_MYSQL ) // if mysql avail!!!
	{
		SQLHENV henv;
		SQLHDBC hdbc;
		SQLHSTMT hstmtTable, hstmtColumn, hstmtIndex;
		SQLINTEGER iTables = 0, iColumns = 0, iIndexParts = 0, iHint, iTmp;
		char szBuffer[ 1024 ];
		W2Asz( pwszMySqlStr, m_szMySqlStr );

		int my_stage = 0;

#define SQL_CHECK(x) if( !SQL_SUCCEEDED(x) ) goto my_failure; else my_stage++;
#define SQL_CHECK_(x) if( !SQL_SUCCEEDED(x) ) goto my_failure; 
#define _SQL_CHECK_(x) if( !SQL_SUCCEEDED(x) ) continue; 
//#define _SQL_CHECK_(x) SQL_CHECK_(x)
#define _SQL_CHECK(x) if( !(x) ) goto my_failure; 

		SQL_CHECK( SQLAllocEnv( &henv ) );
		SQL_CHECK( SQLAllocConnect( henv, &hdbc ) );
		SQL_CHECK( SQLDriverConnect( hdbc, NULL, (BYTE*)m_szMySqlStr, strlen(m_szMySqlStr), NULL, 0, NULL, SQL_DRIVER_NOPROMPT ) );
		SQL_CHECK( SQLAllocStmt( hdbc, &hstmtTable ) );
		SQL_CHECK( SQLAllocStmt( hdbc, &hstmtColumn ) );
		SQL_CHECK( SQLAllocStmt( hdbc, &hstmtIndex ) );
		
		// Everything is ready. Starting to work...
		// a) Calculate necessary size
		SQL_CHECK_( SQLTables( hstmtTable, NULL, 0, NULL, 0, NULL, 0, NULL, 0 ) );
		// Get number of tables
		SQL_CHECK_( SQLRowCount( hstmtTable, &iTables ) );

		while( SQL_SUCCEEDED( SQLFetch( hstmtTable ) ) )
		{
			SQL_CHECK_( SQLGetData( hstmtTable, 3, SQL_C_CHAR, szBuffer, sizeof(szBuffer), &iHint ) );
			int len = strlen(szBuffer);
			
			// Columns of the table
			_SQL_CHECK_( SQLFreeStmt( hstmtColumn, SQL_CLOSE ) );
			_SQL_CHECK_( SQLColumns( hstmtColumn, NULL, 0, NULL, 0, (BYTE*)szBuffer, len, NULL, 0 ) );
			
			// Get number of coulmns in the table
			_SQL_CHECK_( SQLRowCount( hstmtColumn, &iTmp ) );
			iColumns += iTmp;

			// Index parts of the table
			_SQL_CHECK_( SQLFreeStmt( hstmtIndex, SQL_CLOSE ) );
			_SQL_CHECK_( SQLStatistics( hstmtIndex, NULL, 0, NULL, 0, (BYTE*)szBuffer, len, SQL_INDEX_ALL, 0 ) );
			
			// Get number of index parts in the table
			_SQL_CHECK_( SQLRowCount( hstmtIndex, &iTmp ) );
			iIndexParts += iTmp;			
		}

		// b) Allocate memory
		if( !iTables ) iTables = 1;
		_SQL_CHECK( m_pFiles = (SWSTFILE*) malloc( iTables * sizeof(SWSTFILE) ) );
		ZeroMemory( m_pFiles, iTables * sizeof(SWSTFILE) );

		iColumns += iIndexParts; // to fit index names (too much space but no suite workaround)
		if( !iColumns ) iColumns = 1;
		_SQL_CHECK( m_pFields = (SWSTFIELD*) malloc( iColumns * sizeof(SWSTFIELD) ) );
		ZeroMemory( m_pFields, iColumns * sizeof(SWSTFIELD) );

		if( !iIndexParts ) iIndexParts = 1;
		_SQL_CHECK( m_pIndexes = (SWSTINDEX*) malloc( iIndexParts * sizeof(SWSTINDEX) ) );
		ZeroMemory( m_pIndexes, iIndexParts * sizeof(SWSTINDEX) );

		
		// c) Fill buffers
		SQL_CHECK_( SQLFreeStmt( hstmtTable, SQL_CLOSE ) );
		SQL_CHECK_( SQLTables( hstmtTable, NULL, 0, NULL, 0, NULL, 0, NULL, 0 ) );		
		
		m_siFiles = m_siFields = m_siIndexes = m_siRelations = 0;
		
		// Walk through tables
		while( SQL_SUCCEEDED( SQLFetch( hstmtTable ) ) )
		{
			SQL_CHECK_( SQLGetData( hstmtTable, 3, SQL_C_CHAR, m_pFiles[ m_siFiles ].m_szName, sizeof(m_pFiles[ m_siFiles ].m_szName), &iHint ) );
			int len = strlen(m_pFiles[ m_siFiles ].m_szName);
			m_pFiles[ m_siFiles ].m_wID = m_siFiles;
			
			// Columns of the table
			_SQL_CHECK_( SQLFreeStmt( hstmtColumn, SQL_CLOSE ) );
			_SQL_CHECK_( SQLColumns( hstmtColumn, NULL, 0, NULL, 0, (BYTE*)m_pFiles[ m_siFiles ].m_szName, len, NULL, 0 ) );			
			
			MT_LONG siFieldsSaved = m_siFields;
			
			// Walk through columns
			while( SQL_SUCCEEDED( SQLFetch( hstmtColumn ) ) )
			{
				_SQL_CHECK_( SQLGetData( hstmtColumn, 4, SQL_C_CHAR, m_pFields[ m_siFields ].m_szName, sizeof(m_pFields[ m_siFields ].m_szName), &iHint ) );
				m_pFields[ m_siFields ].m_wID = m_siFields;
				m_pFields[ m_siFields ].m_wFile = m_siFiles;

				CHAR szTypeName[ 128 ];
				WCHAR wszTypeName[ 128 ];
				_SQL_CHECK_( SQLGetData( hstmtColumn, 6, SQL_C_CHAR, szTypeName, sizeof(szTypeName), &iHint ) );
				A2Wsz( szTypeName, wszTypeName );
				m_pFields[ m_siFields ].m_btDataType = GetOledbTypeFromName(wszTypeName);

				short iTmp;
				_SQL_CHECK_( SQLGetData( hstmtColumn, 9, SQL_C_SHORT, &iTmp, sizeof(iTmp), &iHint ) );
				m_pFields[ m_siFields ].m_btDec = iTmp;
				_SQL_CHECK_( SQLGetData( hstmtColumn, 8, SQL_C_SHORT, &m_pFields[ m_siFields ].m_wSize, sizeof(m_pFields[ m_siFields ].m_wSize), &iHint ) );
				_SQL_CHECK_( SQLGetData( hstmtColumn, 11, SQL_C_SHORT, &m_pFields[ m_siFields ].m_bNullable, sizeof(m_pFields[ m_siFields ].m_bNullable), &iHint ) );
				
				// Next step
				m_siFields++;			
			}

			// Index parts of the table
			_SQL_CHECK_( SQLFreeStmt( hstmtIndex, SQL_CLOSE ) );
			_SQL_CHECK_( SQLStatistics( hstmtIndex, NULL, 0, NULL, 0, (BYTE*)m_pFiles[ m_siFiles ].m_szName, len, SQL_INDEX_ALL, 0 ) );
			
			MT_WORD wSavedPart = 0, wNumber = 0;
			BOOL bLikePK = FALSE;
			
			// Walk through indexes
			while( SQL_SUCCEEDED( SQLFetch( hstmtIndex ) ) )
			{

				m_pIndexes[ m_siIndexes ].m_wFile = m_siFiles;
				_SQL_CHECK_( SQLGetData( hstmtIndex, 8, SQL_C_SHORT, &m_pIndexes[ m_siIndexes ].m_wPart, sizeof(m_pIndexes[ m_siIndexes ].m_wPart), &iHint ) );
				
				if( m_pIndexes[ m_siIndexes ].m_wPart <= wSavedPart )
					wNumber++; // 2, 1 or 1, 1 --> next index; correct for first pass: 0, 1
				m_pIndexes[ m_siIndexes ].m_wNumber = wNumber;

				if( m_pIndexes[ m_siIndexes ].m_wPart <= wSavedPart || !wSavedPart ) // Next or first index
				{
					// Add index name
					m_pFields[ m_siFields ].m_wID = m_siFields;
					m_pFields[ m_siFields ].m_btDataType = 0xFF; // Named Index
					_SQL_CHECK_( SQLGetData( hstmtIndex, 6, SQL_C_CHAR, m_pFields[ m_siFields ].m_szName, sizeof(m_pFields[ m_siFields ].m_szName), &iHint ) );
					bLikePK = !strcmp(m_pFields[ m_siFields ].m_szName, "PRIMARY"); // Calculate for all parts of the index
					m_pFields[ m_siFields ].m_wFile = m_siFiles;
					m_pFields[ m_siFields ].m_wOffset = wNumber;
					m_siFields++;
				}

				wSavedPart = m_pIndexes[ m_siIndexes ].m_wPart;
				m_pIndexes[ m_siIndexes ].m_wPart--; // starting from 0, not from 1

				// Determine flags
				{ // Collation
				char szBuf[5];
				_SQL_CHECK_( SQLGetData( hstmtIndex, 10, SQL_C_CHAR, szBuf, sizeof(szBuf), &iHint ) );
				if( *szBuf != 'A' )
					m_pIndexes[ m_siIndexes ].m_wFlags |= 0x40;
				}
				{ // Non unique / Primary key
				short iNUniq;
				_SQL_CHECK_( SQLGetData( hstmtIndex, 4, SQL_C_SHORT, &iNUniq, sizeof(iNUniq), &iHint ) );
				if( iNUniq )
					m_pIndexes[ m_siIndexes ].m_wFlags |= 0x1;
				else if( bLikePK ) // Suppose it to be a PK
					m_pIndexes[ m_siIndexes ].m_wFlags |= 0x4000;
				}

				// Determine field ID
				_SQL_CHECK_( SQLGetData( hstmtIndex, 9, SQL_C_CHAR, szBuffer, sizeof(szBuffer), &iHint ) );
				for( MT_LONG w = siFieldsSaved; w < m_siFields; w++ )
					if( !stricmp(m_pFields[ w ].m_szName, szBuffer ) )
						break;
				//_SQL_CHECK( w < m_siFields );
				if( w >= m_siFields )
					continue;
				m_pIndexes[ m_siIndexes ].m_wField = w;

				// Next step
				m_siIndexes++;			
			}
			
			// Next step
			m_siFiles++;
		}

my_failure:
		// Cleaning
		switch( my_stage )
		{
		case 6: SQLFreeStmt( hstmtIndex, SQL_DROP );
		case 5: SQLFreeStmt( hstmtColumn, SQL_DROP );
		case 4: SQLFreeStmt( hstmtTable, SQL_DROP );
		case 3: SQLDisconnect( hdbc );
		case 2: SQLFreeConnect( hdbc );
		case 1: SQLFreeEnv( henv );
		case 0: ;
		}
	}
	else
	{
		//Load list of files
		hr = LoadRows(lpszDDPath, "file.ddf", sizeof(SWSTFILE), 0/*Xf$Id*/, &m_siFiles, (void**)&m_pFiles);
		if (hr != S_OK)
			return hr;

		//Load list of fields
		hr = LoadRows(lpszDDPath, "field.ddf", sizeof(SWSTFIELD), 0/*Xe$Id*/, &m_siFields, (void**)&m_pFields);
		if (hr != S_OK)
			return hr;

		//Load list of indexes
		hr = LoadRows(lpszDDPath, "index.ddf", sizeof(SWSTINDEX), 2/*Xi$File, Xi$Number, Xi$Part*/, &m_siIndexes, (void**)&m_pIndexes);
		if (FAILED( hr ))
			return hr;

		//Load list of relations
		hr = LoadRows(lpszDDPath, "relate.ddf", sizeof(SWSTRELATE), 1/*Xr$FID*/, &m_siRelations, (void**)&m_pRelations);
		if (FAILED( hr ))
			return hr;
	}

	// Calculate number of fields and indexes for each file and create array of field pointer
	for( iFile = 0, pFile = m_pFiles; iFile < m_siFiles; iFile++, pFile++ )
	{
		//Init counters
		pFile->m_wFields = pFile->m_wIndexes = 0;

		//Count fields
		for (iField = 0, pField = m_pFields; iField < m_siFields; iField++, pField++)
			if (pField->m_btDataType < RESERVED_SWST_TYPE_MARGIN && //we handle only real fields
				pFile->m_wID == pField->m_wFile)
					pFile->m_wFields++;

		//Create array of pointers to fields
		if (pFile->m_wFields > 0)
			pFile->m_pFields = (SWSTFIELD**)malloc(sizeof(SWSTFIELD*) * pFile->m_wFields);
		else
			pFile->m_pFields = NULL;

		//Count indexes
		pIndex = m_pIndexes;
		for (iIndex = 0; iIndex < m_siIndexes; iIndex++, pIndex++)
			if( pFile->m_wID == pIndex->m_wFile )
				pFile->m_wIndexes++;

		//Create array of pointers to indexes
		if (pFile->m_wIndexes > 0)
			pFile->m_pIndexes = (SWSTINDEX**)malloc(sizeof(SWSTINDEX*) * pFile->m_wIndexes);
		else
			pFile->m_pIndexes = NULL;

		
		// Set up other fields
		pFile->m_pCatalogOwner = &m_CatalogOwner;
	}

	// Calculate number of segments in parent and dependent indexes
	for( iRelate = 0, pRelate = m_pRelations; iRelate < m_siRelations; iRelate++, pRelate++ )
	{
		//Init counters
		pRelate->m_wParentIndexes = pRelate->m_wDependIndexes = 0;

		// Count segments
		for( iIndex = 0, pIndex = m_pIndexes; iIndex < m_siIndexes; iIndex++, pIndex++ )
		{
			// Parent?
			if( pIndex->m_wFile == pRelate->m_wParentTableID && 
				pIndex->m_wNumber == pRelate->m_wParentIdxNumber )
					pRelate->m_wParentIndexes++;
			// Dependant?
			if( pIndex->m_wFile == pRelate->m_wDependTableID && 
				pIndex->m_wNumber == pRelate->m_wDependIdxNumber )
					pRelate->m_wDependIndexes++;
		}
	
		//Create array of pointers to segments 
		if (pRelate->m_wParentIndexes > 0)
			pRelate->m_ppParentIndex = (SWSTINDEX**)malloc(sizeof(SWSTINDEX*) * pRelate->m_wParentIndexes);
		else
			pRelate->m_ppParentIndex = NULL;
		
		if (pRelate->m_wDependIndexes > 0)
			pRelate->m_ppDependIndex = (SWSTINDEX**)malloc(sizeof(SWSTINDEX*) * pRelate->m_wDependIndexes);
		else
			pRelate->m_ppDependIndex = NULL;

		// Reset counters to count again
		pRelate->m_wParentIndexes = pRelate->m_wDependIndexes = 0;
	}
	
	// Clean fields, which may ne not filled
	for( iField = 0, pField = m_pFields; iField < m_siFields; iField++, pField++ )
		pField->Clean();
	for( iIndex = 0, pIndex = m_pIndexes; iIndex < m_siIndexes; iIndex++, pIndex++ )
		pIndex->Clean();
	
	//Fill out array of pointers and trim strings
	for (iFile = 0, pFile = m_pFiles; iFile < m_siFiles; iFile++, pFile++)
	{
		////////////////// Files //////////////////
		//Trim strings
		TrimRight(pFile->m_szName, sizeof(pFile->m_szName));
		TrimRight(pFile->m_szLocation, sizeof(pFile->m_szLocation));

		/////////// Indexes ////////////////////////
		//Initialize pointer to index links
		ppLinkIndex = pFile->m_pIndexes;

		//Count indexes
		for (iIndex = 0, pIndex = m_pIndexes; iIndex < m_siIndexes; iIndex++, pIndex++)
		{
			if( pFile->m_wID == pIndex->m_wFile ) // Mine
			{
				*ppLinkIndex = pIndex;
				ppLinkIndex++;

				// Initialize relations
				for( iRelate = 0, pRelate = m_pRelations; iRelate < m_siRelations; iRelate++, pRelate++ )
				{
					// Parent index?
					if( pRelate->m_wParentTableID == pFile->m_wID &&
						pRelate->m_wParentIdxNumber == pIndex->m_wNumber )
							pRelate->m_ppParentIndex[ pRelate->m_wParentIndexes++ ] = pIndex;
					// Dependent index ?
					if( pRelate->m_wDependTableID == pFile->m_wID &&
						pRelate->m_wDependIdxNumber == pIndex->m_wNumber )
					{
						pRelate->m_ppDependIndex[ pRelate->m_wDependIndexes++ ] = pIndex;

						// Name of the dependant index which is a foreign key
						TrimRight(pRelate->m_szName, sizeof(pRelate->m_szName));
						pIndex->m_pSwstRelateName = pRelate;  
					}
				}
			}
		}

		///////////////////// Fields ///////////////
		//Initialize pointer to field links
		ppLiskField = pFile->m_pFields;

		//Count fields
		for (iField = 0, pField = m_pFields; iField < m_siFields; iField++, pField++)
		{
			if( pFile->m_wID == pField->m_wFile ) // Mine
			{
			   // File - "father"
			   pField->m_pSwstFile = pFile;

			   if( pField->m_btDataType < RESERVED_SWST_TYPE_MARGIN ) //we handle only real fields
			   {
					*ppLiskField = pField;
					ppLiskField++;
					
					//Trim name
					TrimRight(pField->m_szName, sizeof(pField->m_szName));
					
					/// Handle LONGVAR types: set field size to enough huge value
					if( pField->m_btDataType == LONGVAR_TYPE )
						pField->m_wSize = MAXSUPPORTEDLEN_LONGVARTYPE;

					////// Search if the field is in an index
				    for (iIndex = 0, pIndex = m_pIndexes; iIndex < m_siIndexes; iIndex++, pIndex++)
						if( pField->m_wID == pIndex->m_wField )
							pIndex->m_pSwstField = pField;
			   }
			   else if( pField->m_btDataType == 0xFF ) // Named Index
			   {
					//Trim name
					TrimRight(pField->m_szName, sizeof(pField->m_szName));
			   	    // Set up index name
				    for (iIndex = 0, pIndex = m_pIndexes; iIndex < m_siIndexes; iIndex++, pIndex++)
						if( pField->m_wFile == pIndex->m_wFile &&
							pField->m_wOffset == pIndex->m_wNumber )
								pIndex->m_pSwstFieldName = pField;
			   }
			}
		}

		// Sort fields by m_wID
		/*for (int j = pFile->m_wFields  - 1; j > 0; j--)
		{
			for (int k = 0; k < j; k++)
			{
				if (pFile->m_pFields[k]->m_wID > pFile->m_pFields[k + 1]->m_wID )
				{
					pField = pFile->m_pFields[k];
					pFile->m_pFields[k] = pFile->m_pFields[k + 1];
					pFile->m_pFields[k + 1] = pField;
				}
			}
		}*/
	}

	// Sort segments in ascending order
	/*for( iRelate = 0, pRelate = m_pRelations; iRelate < m_siRelations; iRelate++, pRelate++ )
	{
		// Sort segments of parent index
		for( int j = pRelate->m_wParentIndexes - 1; j > 0; j-- )
			for (int k = 0; k < j; k++)
				if (pRelate->m_ppParentIndex[k]->m_wPart > pRelate->m_ppParentIndex[k + 1]->m_wPart )
				{
					pIndex = pRelate->m_ppParentIndex[k];
					pRelate->m_ppParentIndex[k] = pRelate->m_ppParentIndex[k + 1];
					pRelate->m_ppParentIndex[k + 1] = pIndex;
				}
		
		// Sort segments of dependent index
		for( j = pRelate->m_wDependIndexes - 1; j > 0; j-- )
			for (int k = 0; k < j; k++)
				if (pRelate->m_ppDependIndex[k]->m_wPart > pRelate->m_ppDependIndex[k + 1]->m_wPart )
				{
					pIndex = pRelate->m_ppDependIndex[k];
					pRelate->m_ppDependIndex[k] = pRelate->m_ppDependIndex[k + 1];
					pRelate->m_ppDependIndex[k + 1] = pIndex;
				}
	}*/

	// Store Data Dictionary Path, catalogue name, owner name etc.
	strcpy0(m_szDdfPath, lpszDDPath, MAXSTR( m_szDdfPath ) );
	strcpy0(m_szDataPath, lpszDataPath, MAXSTR( m_szDataPath ) );
	memcpy(m_CatalogOwner.m_wszCatalog, lpwszDatabaseName, sizeof(m_CatalogOwner.m_wszCatalog) ); 
	m_CatalogOwner.m_wszCatalog[ MAXSTR(m_CatalogOwner.m_wszCatalog) - 1 ] = L'\0';
	wcscpy0(m_CatalogOwner.m_wszOwner,	lpwszOwner ? lpwszOwner : L"", MAXSTR(m_CatalogOwner.m_wszOwner) );
	m_CatalogOwner.m_type = typeOfDataSource;
	m_iDriverID = iDriverID;
	strcpy0( m_szUser, lpszUser, MAXSTR(m_szUser) );
	strcpy0( m_szPassword, lpszPassword, MAXSTR(m_szPassword) );

    return S_OK;
}

// Returns pointer to the file description with specified name
// Returns NULL if no file is found
SWSTFILE* CSwstMeta::FindFile(LPCSTR pszName)
{
	SWSTFILE* pFile = m_pFiles;
	for (MT_SINT i = 0; i < m_siFiles; i++, pFile++)
	{
		if (stricmp(pszName, pFile->m_szName) == 0)
			return pFile;
	}

	return NULL;
}


HRESULT CSwstMeta::SwstType2OledbTypeHelper
	(
	WORD		wSrcType,			//@parm IN	| Type name
	DWORD		wSrcSize,			//@parm IN	| Type length	
	WORD		wSrcDec,			//@parm IN	| Type decimals
	BOOL		bNullable,			//@parm IN	| Nullable
	BOOL		bUpdatable,			//@parm IN	| Updatable
	WORD*		pwOledbType,		//@parm OUT	| OLEDB Type name
	DWORD*		pdwOledbFlags,		//@parm OUT | OLEDB Type flags
	DWORD*		pdwOledbLength,		//@parm OUT	| OLEDB Type length	
	WORD*		pwOledbPrecision,	//@parm OUT | OLEDB Type precision
	WORD*		pwOledbScale		//@parm OUT | OLEDB Type scale
	)
{
	*pwOledbType = wSrcType;
	
	*pdwOledbLength = MIN(wSrcSize, MAX_BIND_LEN);

	//Calculate precision
	if(*pwOledbType != DBTYPE_STR)
		*pwOledbPrecision = *pdwOledbLength;
	else
		*pwOledbPrecision = 0;

	//Calculate scale
	*pwOledbScale = wSrcDec;

	//Calculate flags
	if( bUpdatable )
		*pdwOledbFlags = DBCOLUMNFLAGS_WRITE; 

	//All columns (except strings and bytes) are fixed length
	if (*pwOledbType != DBTYPE_STR && *pwOledbType != DBTYPE_BYTES)
		*pdwOledbFlags |= DBCOLUMNFLAGS_ISFIXEDLENGTH;

	//Nullable
	if( bNullable == -1 ) 
		bNullable = IsNullable( *pwOledbType );
	if( bNullable )
		*pdwOledbFlags |= DBCOLUMNFLAGS_ISNULLABLE;

    return S_OK;
}

///////////////////////////////////////////////
// CSwstMetaHolder
///////////////////////////////////////////////

CSwstMetaHolder::CSwstMetaHolder( int base ) 
{ 
	CLEAR_CONSTRUCT( CSwstMetaHolder );
	m_nMaxMetasBase = base;	// Base to enlarge
	m_nMaxMetas = m_nMaxMetasBase;	// Current size
	m_holder = new CSwstMeta*[ m_nMaxMetas ];
	ZeroMemory( m_holder, m_nMaxMetas * sizeof(CSwstMeta*) );
}


CSwstMetaHolder::~CSwstMetaHolder() 
{
	if( m_holder )
	{
		for( int i = 0; i < m_nMaxMetas; i++ )
			if( m_holder[ i ] != NULL )
				delete m_holder[ i ]; // temporary CSwstMeta is not a COM class
		delete m_holder;
	}
}


// Get elem at position
HRESULT CSwstMetaHolder::At(int i, CSwstMeta** ppMeta ) 
{
	if( ppMeta == NULL )
		return E_INVALIDARG;
	if( m_holder == NULL || i >= m_nMaxMetas )
	{
		*ppMeta = NULL;
		return S_FALSE;;
	}
	else
	{
		*ppMeta = m_holder[ i ];
		return ( *ppMeta != NULL ) ? S_OK : S_FALSE;
	}
}


// Get elem at position with catalogue. 
// S_OK if elem is got, E_FAIL else.
// ppMeta may be NULL
HRESULT CSwstMetaHolder::At( LPCOLESTR szDatabaseName, LPCOLESTR szOwner, CSwstMeta** ppMeta )
{
	CSwstMeta* pMeta;
	for( int i = 0; i < m_uiFirstFree; i++ )
		if( At( i, &pMeta ) == S_OK && 
			!wcsicmp( szDatabaseName, pMeta->m_CatalogOwner.m_wszCatalog ) &&
			!wcscmp( szOwner ? szOwner : L"", pMeta->m_CatalogOwner.m_wszOwner ) )
			break;
	if( i == m_uiFirstFree )
		return E_FAIL;
	if( ppMeta != NULL )
		*ppMeta = pMeta;
	return S_OK;
}


// Get maximum element number
HRESULT CSwstMetaHolder::GetMaxNumber( int* puiMaxNumber )
{
	 if( puiMaxNumber == NULL )
		 return E_INVALIDARG;
	 *puiMaxNumber = m_uiFirstFree;
	 return S_OK;
}

// Get first free slot
HRESULT CSwstMetaHolder::GetFreeSlotNumber( int* pnSlot )
{
	if( pnSlot == NULL )
		return E_INVALIDARG;
	
	if( m_uiFirstFree >= m_nMaxMetas )
	{
		CSwstMeta** holder = new CSwstMeta*[ m_nMaxMetas + m_nMaxMetasBase ];
		if( holder == NULL )
			return E_FAIL;
		memcpy( holder, m_holder, m_nMaxMetas * sizeof( CSwstMeta* ) );
		memset( holder + m_nMaxMetas, 0, m_nMaxMetasBase * sizeof( CSwstMeta* ) );
		m_nMaxMetas += m_nMaxMetasBase;
		delete m_holder;
		m_holder = holder;
	}

	m_holder[ m_uiFirstFree ] = new CSwstMeta;
	if( m_holder[ m_uiFirstFree ] == NULL )
		return E_OUTOFMEMORY;
	*pnSlot = m_uiFirstFree;
	m_uiFirstFree++;

	return S_OK;
}
	

// Creates temporary Named DB name and/or ODBC DSN name if they are necessary (P.SQL 2000 )
HRESULT CSwstMeta::CreateTemporaryStorageNames(CSwstMeta* pSwstMetaINFORMATION_SCHEMA, LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverType, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword )
{
	return S_OK;	// Correct 
}


//Loads data from file.ddf and field.ddf
HRESULT CSwstMetaHolder::LoadMetaData(LPCSTR lpszDDPath, LPCSTR lpszDataPath, LPCOLESTR lpwszDatabaseName, LPCOLESTR lpwszOwner, DATASOURCE_TYPE typeOfDataSource, BYTE iDriverType, LPSTR lpszServerName, LPSTR lpszUser, LPSTR lpszPassword, LPOLESTR pwszMySqlStr )
{
	// Nothing to do if Meta is already loaded
	if( SUCCEEDED( At(lpwszDatabaseName, lpwszOwner, NULL) ) )
		return S_OK;
	
	// Allocate new meta
	int slot;
	HRESULT hr = GetFreeSlotNumber( &slot );
	if( FAILED( hr ) )
			return hr;

	CSwstMeta* pMeta;
	if( At( slot, &pMeta ) != S_OK )
		return E_FAIL;

	// Get INFORMATION_SCHEMA's meta. NULL if current mata is INFORMATION_SCHEMA
	CSwstMeta* pMetaINFORMATION_SCHEMA = NULL;
	if( lpwszOwner != NULL && *lpwszOwner != L'\0' && 
		At( lpwszDatabaseName, NULL, &pMetaINFORMATION_SCHEMA ) != S_OK )
			return E_FAIL;

	hr = pMeta->LoadMetaData( pMetaINFORMATION_SCHEMA, lpszDDPath, lpszDataPath, 
		lpwszDatabaseName, lpwszOwner, typeOfDataSource, iDriverType, lpszServerName, 
		lpszUser, lpszPassword, pwszMySqlStr );

	if( FAILED( hr ) )
		ReleaseSlot( slot );
	
	return hr;
}


//Release slot
HRESULT CSwstMetaHolder::ReleaseSlot(int slot) 
{
	CSwstMeta* pMeta;
	if( At( slot, &pMeta ) != S_OK )
		return E_FAIL;

	m_holder[ slot ] = NULL;

	return S_OK;
}


// Returns pointer to the file description with specified name
SWSTFILE* CSwstMetaHolder::FindFile(int i, LPCSTR pszName)
{
	CSwstMeta* pMeta;
	if( At( i, &pMeta ) != S_OK )
		return NULL;

	return pMeta->FindFile( pszName );
}


//Retrieve  version 
HRESULT CSwstMetaHolder::GetVersion(int i, float* pfltVersion)
{
	CSwstMeta* pMeta;
	if( At( i, &pMeta ) != S_OK )
		return E_INVALIDARG;
	
	return S_OK; //pMeta->GetVersion( pfltVersion );
}

bool IsNullable( DBTYPE type )
{
	switch( type )
	{
	case DBTYPE_DBDATE:
	case DBTYPE_DBTIME:
	case DBTYPE_DBTIMESTAMP:
	case DBTYPE_R8:
	case DBTYPE_R4:
	case DBTYPE_CY:
	case DBTYPE_STR:
	case DBTYPE_BYTES:
		return true;
	default:
		return false;
	}
}
