/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _CLASSFAC_H_
#define _CLASSFAC_H_

// Classes -------------------------------------------------------------------
//----------------------------------------------------------------------------
// @class CClassFactory 
//
class CClassFactory : public IClassFactory2		//@base public | IClassFactory
{
	START_CLASS(); 

	protected: //@access protected
		//@cmember Reference count
		ULONG			m_cRef;
		CLSID			m_CLSID;

		HRESULT			StartUp();
		STDMETHODIMP	CreateInstanceHelper(LPUNKNOWN, REFIID, LPVOID *);

	public: // @access public
		//@cmember Constructor
		CClassFactory( REFCLSID refCLSID );
		//@cmember Destructor
		~CClassFactory(void);

		//	IUnknown members
		//@cmember Request an Interface
		STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
		//@cmember Increments the Reference count
		STDMETHODIMP_(ULONG)	AddRef(void);
		//@cmember Decrements the Reference count
		STDMETHODIMP_(ULONG)	Release(void);

		//	IClassFactory members
		//@cmember Instantiates an uninitialized instance of an object
		STDMETHODIMP			CreateInstance(LPUNKNOWN, REFIID, LPVOID *);
	    //@cmember Lock Object so that it can not be unloaded
		STDMETHODIMP			LockServer(BOOL);

        // IClassFactory2 methods.
        STDMETHODIMP         GetLicInfo(LPLICINFO);
        STDMETHODIMP         RequestLicKey(DWORD, BSTR*);
        STDMETHODIMP         CreateInstanceLic(
                               IUnknown*,
                               IUnknown*,
                               REFIID,
                               BSTR,
                               LPVOID*);

	FINISH_CLASS(); 
};

#endif

