/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//cache_getpath.cpp

/** @pkg cache_val.getpath */

/**
 * Reduces actual number of of calls to GetPathByAnyDatabaseName which is now reffered as GetPathByAnyDatabaseName
 *
 * @author     Fedor Chelnokov, fchel@mail.ru
 *
 * @version    <ul><li>Created on July 17, 2000
 * @version    <li>Modified on July 20, 2000</ul>
 *
 * @pkgdoc cache_val.getpath
 */

#include    "hfiles.h"
#include    "headers.h"
#include    "cache_val.h"
#include    "enumdb.h"

/** input parameters */
class GetPathIn
{
public:
    GetPathIn() { *szDataSource = '\0'; *szDataPath = '\0'; Type = DATASOURCE_NONE; }
    bool operator ==( const GetPathIn &cmp ) { 
        //equal if DataSources are equal
        bool res = true;
        return strcmp( szDataSource, cmp.szDataSource ) == 0; 
    }

	char szDataSource[ MAXDDFPATH+1 ]; 
	char szDataPath[ MAXDDFPATH+1 ]; 
    DATASOURCE_TYPE Type;
};

/** output parameters */
class GetPathOut
{
public:
    /** calls GetPathByAnyDatabaseName */
    void update( GetPathIn &in ) 
    { 
        *szDDFPath = '\0';
        iDriverID = 0;
        bValidDataSource = GetPathByAnyDatabaseName_Slow( in.szDataSource, szDDFPath, in.szDataPath, &in.Type, &iDriverID );
    }

    void release() {}

    //data members
	char szDDFPath[ MAXDDFPATH+1 ]; 
	BYTE iDriverID;
    BOOL bValidDataSource;
};

// Cached wrapper for GetPathByAnyDatabaseName_Slow();
// Parameters:
//  [in/out]   lpszDataSource, lpszDataPath, pType
//  [out only] lpszDDFPath, piDriverID
//
BOOL GetPathByAnyDatabaseName( char* lpszDataSource, char* lpszDDFPath, char* lpszDataPath, DATASOURCE_TYPE* pType, BYTE* piDriverID )
{
    GetPathIn in;
	strcpy0( in.szDataSource, lpszDataSource, MAXSTR(in.szDataSource) ); 
	strcpy0( in.szDataPath, lpszDataPath, MAXSTR(in.szDataPath) ); 
    if( pType ) in.Type = *pType;

    static CacheVal< GetPathOut, GetPathIn > path_cache;
    GetPathOut& path = path_cache.update( in );

	strcpy0( lpszDataSource, in.szDataSource, MAXSTR(in.szDataSource) ); 
	strcpy0( lpszDataPath, in.szDataPath, MAXSTR(in.szDataPath) ); 
    strcpy0( lpszDDFPath, path.szDDFPath, MAXSTR(path.szDDFPath) );
    if( pType ) *pType = in.Type;
    *piDriverID = path.iDriverID;
    return path.bValidDataSource;
}

