/* Copyright (C) 2000, 2001  SWsoft, Singapore                                  
 *                                                                              
 *  This program is free software; you can redistribute it and/or modify        
 *  it under the terms of the GNU General Public License as published by        
 *  the Free Software Foundation; either version 2 of the License, or           
 *  (at your option) any later version.                                         
 *                                                                              
 *  This program is distributed in the hope that it will be useful,             
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of              
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 *  GNU General Public License for more details.                                
 *                                                                              
 *  You should have received a copy of the GNU General Public License           
 *  along with this program; if not, write to the Free Software                 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   
 */

#ifndef _ASSERTS_H_
#define _ASSERTS_H_

//-----------------------------------------------------------------------------
// Global function prototypes -- helper stuff
//-----------------------------------------------------------------------------

// The assert and trace macros below calls these.
void OLEDB_Assert(LPSTR expression, LPSTR filename, long linenum);

void OLEDB_Trace(const char* format, ...);

//-----------------------------------------------------------------------------
// Debugging macros
//-----------------------------------------------------------------------------

// Ensure "DEBUG" is set if "_DEBUG" is set.
#ifdef _DEBUG
# ifndef DEBUG
#  define DEBUG 1
# endif
#endif

// Ensure no previous versions of our macros.
#ifdef  assert
# undef assert
#endif
#ifdef  Assert
# undef Assert
#endif
#ifdef  ASSERT
# undef ASSERT
#endif
#ifdef  TRACE
# undef TRACE
#endif
#ifdef  TRACE2
# undef TRACE2
#endif
#ifdef  TRACE3
# undef TRACE3
#endif
#ifdef  TRACE4
# undef TRACE4
#endif
#ifdef  TRACE5
# undef TRACE5
#endif
#ifdef  TRACE6
# undef TRACE6
#endif


#ifdef DEBUG
# define assert(x) { if ( ! (x) ) OLEDB_Assert( #x, __FILE__, __LINE__ ); }
# define Assert(x) assert(x)
# define ASSERT(x) assert(x)
# define VERIFY(x) assert(x)
# define TRACE  OLEDB_Trace
# define TRACE1  OLEDB_Trace
# define TRACE2  OLEDB_Trace
# define TRACE3  OLEDB_Trace
# define TRACE4  OLEDB_Trace
# define TRACE5  OLEDB_Trace
# define TRACE6  OLEDB_Trace
# define DEBUGCODE(p) p
#else	// DEBUG
# define assert(x)  ((void)0)
# define Assert(x)  ((void)0)
# define ASSERT(x)  ((void)0)
# define VERIFY(x)  ((void)(x))
//# define TRACE  OLEDB_Trace
//  inline void OLEDB_Trace( const char *format, ... ) { /* do nothing */ }
# define TRACE(a) {}  /* do nothing */
# define TRACE2(a, b) {}  /* do nothing */
# define TRACE3(a, b, c) {}  /* do nothing */
# define TRACE4(a, b, c, d) {}  /* do nothing */
# define TRACE5(a, b, c, d, e)  {} /* do nothing */
# define TRACE6(a, b, c, d, e, f)  {} /* do nothing */
# define DEBUGCODE(p)
#endif	// DEBUG

#endif
