layout = [ ( 'General',
    [ ( 'Features',
        [ 'enable-locking',
          'enable-pstack',
          'event-scheduler',
          'federated',
          'isam',
          'plugin',
          'plugin-load',
          'plugin-load-add',
          'profiling_history_size',
          'skip-partition']),
      ('Transactions', ['autocommit']),
      ( 'Memory usage',
        [ 'join_buffer_size',
          'join_cache_level',
          'large-pages',
          'query_alloc_block_size',
          'sort_buffer_size']),
      ('Informational', ['server-id']),
      ('Directories', ['basedir', 'datadir', 'plugin_dir', 'tmpdir']),
      ( 'System',
        [ 'core-file',
          'external-locking',
          'gdb',
          'ignore-db-dir',
          'lower_case_table_names',
          'offline_mode',
          'persisted_globals_load',
          'pid-file',
          'skip-host-cache',
          'skip-locking',
          'skip-safemalloc',
          'skip-stack-trace',
          'skip-symlink',
          'skip_external_locking',
          'symbolic-links',
          'sysdate-is-now',
          'use-symbolic-links',
          'user']),
      ( 'General',
        [ 'big-tables',
          'default-storage-engine',
          'default-table-type',
          'default_tmp_storage_engine',
          'init-file',
          'lock_wait_timeout',
          'max_long_data_size',
          'old',
          'one-thread',
          'session_track_gtids',
          'session_track_schema',
          'session_track_state_change',
          'session_track_system_variables',
          'stored_program_cache',
          'super-large-pages']),
      ( 'Firewall',
        [ 'mysql_firewall_max_query_size',
          'mysql_firewall_mode',
          'mysql_firewall_trace']),
      ( 'SQL',
        [ 'ansi',
          'explicit_defaults_for_timestamp',
          'parser_max_mem_size',
          'sql-bin-update-same',
          'sql-mode']),
      ( 'International',
        [ 'character-set-filesystem',
          'character-set-server',
          'character-sets-dir',
          'collation-server',
          'default-character-set',
          'default-collation',
          'default-time-zone',
          'default_week_format',
          'language',
          'lc-messages',
          'lc-messages-dir',
          'skip-character-set-client-handshake']),
      ( 'Backup',
        [ 'backup_elevation',
          'backup_history_log',
          'backup_history_log_file',
          'backup_progress_log',
          'backup_progress_log_file',
          'backupdir',
          'log-backup-output',
          'mysql-backup'])]),
  ( 'Logging',
    [ ( 'Audit',
        [ 'audit-log',
          'audit_log_buffer_size',
          'audit_log_connection_policy',
          'audit_log_exclude_accounts',
          'audit_log_file',
          'audit_log_format',
          'audit_log_include_accounts',
          'audit_log_policy',
          'audit_log_rotate_on_size',
          'audit_log_statement_policy',
          'audit_log_strategy']),
      ( 'Slow query log options',
        [ 'log-slow-admin-statements',
          'log-slow-queries',
          'log-slow-slave-statements',
          'long_query_time',
          'slow_query_log_file']),
      ( 'Advanced log options',
        [ 'expire_logs_days',
          'log-long-format',
          'log-tc',
          'log-tc-size',
          'log-warnings']),
      ( 'General',
        [ 'console',
          'general-log',
          'general_log_file',
          'log',
          'log-error',
          'log-isam',
          'log-output',
          'log-queries-not-using-indexes',
          'log-raw',
          'log-short-format',
          'log_backward_compatible_user_definitions',
          'log_builtin_as_identified_by_password',
          'log_error_verbosity',
          'log_slave_updates',
          'log_syslog',
          'log_syslog_facility',
          'log_syslog_include_pid',
          'log_syslog_tag',
          'log_timestamps',
          'slow-query-log']),
      ( 'Binlog Options',
        [ 'binlog-checksum',
          'binlog-do-db',
          'binlog-format',
          'binlog-ignore-db',
          'binlog-row-event-max-size',
          'binlog-rows-query-log-events',
          'binlog_cache_size',
          'binlog_direct_non_transactional_updates',
          'binlog_error_action',
          'binlog_group_commit_sync_delay',
          'binlog_group_commit_sync_no_delay_count',
          'binlog_gtid_simple_recovery',
          'binlog_row_image',
          'binlog_stmt_cache_size',
          'binlogging_impossible_mode',
          'log-bin',
          'log-bin-index',
          'log-bin-trust-function-creators',
          'log-bin-trust-routine-creators',
          'log_bin_use_v1_row_events',
          'max-binlog-dump-events',
          'max_binlog_cache_size',
          'max_binlog_size',
          'max_binlog_stmt_cache_size',
          'sporadic-binlog-dump-fail',
          'sync_binlog'])]),
  ( 'InnoDB',
    [ ( 'Datafiles',
        [ 'innodb_data_file_path',
          'innodb_data_home_dir',
          'innodb_file_format',
          'innodb_file_format_check',
          'innodb_file_format_max']),
      ( 'Buffer pool',
        [ 'innodb_buffer_pool_awe_mem_mb',
          'innodb_buffer_pool_chunk_size',
          'innodb_buffer_pool_dump_at_shutdown',
          'innodb_buffer_pool_dump_now',
          'innodb_buffer_pool_filename',
          'innodb_buffer_pool_instances',
          'innodb_buffer_pool_load_abort',
          'innodb_buffer_pool_load_at_startup',
          'innodb_buffer_pool_load_now',
          'innodb_buffer_pool_size']),
      ( 'Logfiles',
        [ 'innodb_flush_log_at_trx_commit',
          'innodb_flush_method',
          'innodb_flush_neighbors',
          'innodb_flush_sync',
          'innodb_log_arch_dir',
          'innodb_log_archive',
          'innodb_log_buffer_size',
          'innodb_log_checksum_algorithm',
          'innodb_log_checksums',
          'innodb_log_compressed_pages',
          'innodb_log_file_size',
          'innodb_log_files_in_group',
          'innodb_log_group_home_dir',
          'innodb_log_write_ahead_size',
          'innodb_mirrored_log_groups',
          'innodb_online_alter_log_max_size',
          'innodb_undo_directory',
          'innodb_undo_log_truncate',
          'innodb_undo_logs']),
      ('Various', ['innodb_fast_shutdown']),
      ( 'Memory',
        [ 'innodb_buffer_pool_instances',
          'innodb_buffer_pool_size',
          'innodb_additional_mem_pool_size',
          'innodb_page_cleaners',
          'innodb_page_size',
          'innodb_sort_buffer_size']),
      ( 'Fulltext search',
        [ 'innodb_ft_aux_table',
          'innodb_ft_cache_size',
          'innodb_ft_enable_diag_print',
          'innodb_ft_enable_stopword',
          'innodb_ft_max_token_size',
          'innodb_ft_min_token_size',
          'innodb_ft_num_word_optimize',
          'innodb_ft_result_cache_limit',
          'innodb_ft_server_stopword_table',
          'innodb_ft_sort_pll_degree',
          'innodb_ft_total_cache_size',
          'innodb_ft_user_stopword_table',
          'innodb_optimize_fulltext_only',
          'mecab_rc_file',
          'ngram_token_size']),
      ( 'General',
        [ 'ignore-builtin-innodb',
          'innodb-safe-binlog',
          'innodb-status-file',
          'innodb_adaptive_flushing',
          'innodb_adaptive_flushing_lwm',
          'innodb_adaptive_hash_index',
          'innodb_adaptive_hash_index_parts',
          'innodb_adaptive_max_sleep_delay',
          'innodb_api_bk_commit_interval',
          'innodb_api_disable_rowlock',
          'innodb_api_enable_binlog',
          'innodb_api_enable_mdl',
          'innodb_api_trx_level',
          'innodb_autoextend_increment',
          'innodb_autoinc_lock_mode',
          'innodb_background_drop_list_empty',
          'innodb_buffer_pool_dump_pct',
          'innodb_change_buffer_max_size',
          'innodb_change_buffering',
          'innodb_change_buffering_debug',
          'innodb_checksum_algorithm',
          'innodb_checksums',
          'innodb_cmp_per_index_enabled',
          'innodb_commit_concurrency',
          'innodb_compress_debug',
          'innodb_compression_failure_threshold_pct',
          'innodb_compression_level',
          'innodb_compression_pad_pct_max',
          'innodb_concurrency_tickets',
          'innodb_create_intrinsic',
          'innodb_default_row_format',
          'innodb_disable_sort_file_cache',
          'innodb_disable_resize_buffer_pool_debug',
          'innodb_doublewrite',
          'innodb_extra_dirty_writes',
          'innodb_file_io_threads',
          'innodb_file_per_table',
          'innodb_fill_factor',
          'innodb_flushing_avg_loops',
          'innodb_force_load_corrupted',
          'innodb_force_recovery',
          'innodb_io_capacity',
          'innodb_io_capacity_max',
          'innodb_large_prefix',
          'innodb_limit_optimistic_insert_debug',
          'innodb_lock_wait_timeout',
          'innodb_locks_unsafe_for_binlog',
          'innodb_lru_scan_depth',
          'innodb_max_dirty_pages_pct',
          'innodb_max_dirty_pages_pct_lwm',
          'innodb_max_merged_io',
          'innodb_max_purge_lag',
          'innodb_max_purge_lag_delay',
          'innodb_max_undo_log_size',
          'innodb_merge_threshold_set_all_debug',
          'innodb_monitor_disable',
          'innodb_monitor_enable',
          'innodb_monitor_reset',
          'innodb_monitor_reset_all',
          'innodb_numa_interleave',
          'innodb_old_blocks_pct',
          'innodb_old_blocks_time',
          'innodb_online_alter_log_max_size',
          'innodb_open_files',
          'innodb_optimize_fulltext_only',
          'innodb_optimize_point_storage',
          'innodb_print_all_deadlocks',
          'innodb_purge_batch_size',
          'innodb_purge_rseg_truncate_frequency',
          'innodb_purge_threads',
          'innodb_random_read_ahead',
          'innodb_read_ahead_threshold',
          'innodb_read_io_threads',
          'innodb_read_only',
          'innodb_replication_delay',
          'innodb_rollback_on_timeout',
          'innodb_rollback_segments',
          'innodb_saved_page_number_debug',
          'innodb_sort_buffer_size',
          'innodb_spin_wait_delay',
          'innodb_stats_auto_recalc',
          'innodb_stats_include_delete_marked',
          'innodb_stats_method',
          'innodb_stats_on_metadata',
          'innodb_stats_persistent',
          'innodb_stats_persistent_sample_pages',
          'innodb_stats_sample_pages',
          'innodb_stats_transient_sample_pages',
          'innodb_status_output',
          'innodb_status_output_locks',
          'innodb_strict_mode',
          'innodb_support_xa',
          'innodb_sync_array_size',
          'innodb_sync_spin_loops',
          'innodb_sync_debug',
          'innodb_table_locks',
          'innodb_temp_data_file_path',
          'innodb_tmpdir',
          'innodb_thread_concurrency',
          'innodb_thread_concurrency_timer_based',
          'innodb_thread_sleep_delay',
          'innodb_trx_purge_view_update_only_debug',
          'innodb_trx_rseg_n_slots_debug',
          'innodb_undo_directory',
          'innodb_undo_log_truncate',
          'innodb_undo_logs',
          'innodb_undo_tablespaces',
          'innodb_use_legacy_cardinality_algorithm',
          'innodb_use_native_aio',
          'innodb_use_sys_malloc',
          'innodb_write_io_threads',
          'internal_tmp_disk_storage_engine',
          'timed_mutexes',
          'skip-innodb'])]),
  ( 'Networking',
    [ ('Data / Memory size', ['max_allowed_packet', 'net_buffer_length']),
      ( 'SSL',
        [ 'ssl',
          'ssl-ca',
          'ssl-capath',
          'ssl-cert',
          'ssl-cipher',
          'ssl-crl',
          'ssl-crlpath',
          'ssl-key']),
      ( 'Timeout Settings',
        [ 'connect_timeout',
          'interactive_timeout',
          'net_read_timeout',
          'net_write_timeout',
          'wait_timeout']),
      ( 'Advanced',
        [ 'max_connect_errors',
          'max_connections',
          'max_user_connections',
          'net_retry_count']),
      ( 'General',
        [ 'bind-address',
          'enable-named-pipe',
          'port',
          'port-open-timeout',
          'skip-name-resolve',
          'skip-networking',
          'socket'])]),
  ( 'Advanced',
    [ ( 'Transactions',
        [ 'completion_type',
          'transaction-isolation',
          'transaction-read-only',
          'transaction_alloc_block_size',
          'transaction_prealloc_size']),
      ( 'Deprecated',
        ['old-alter-table', 'old-protocol', 'set-variable', 'warnings']),
      ( 'Thread specific settings',
        [ 'slow_launch_time',
          'thread_cache_size',
          'thread_concurrency',
          'thread_handling',
          'thread_pool_algorithm',
          'thread_pool_high_priority_connection',
          'thread_pool_max_unused_threads',
          'thread_pool_prio_kickup_timer',
          'thread_pool_size',
          'thread_pool_stall_limit',
          'thread_stack']),
      ( 'Various',
        [ 'bulk_insert_buffer_size',
          'group_concat_max_len',
          'key_cache_block_size',
          'key_cache_division_limit',
          'max_execution_time',
          'max_heap_table_size',
          'max_join_size',
          'max_length_for_sort_data',
          'max_points_in_geometry',
          'max_seeks_for_key',
          'max_sort_length',
          'max_write_lock_count',
          'multi_range_count',
          'new',
          'preload_buffer_size',
          'query_alloc_block_size',
          'query_prealloc_size',
          'range_alloc_block_size',
          'range_optimizer_max_mem_size',
          'read_buffer_size',
          'read_rnd_buffer_size',
          'tmp_table_size']),
      ( 'Insert delayed settings',
        [ 'delayed_insert_limit',
          'delayed_insert_timeout',
          'delayed_queue_size',
          'max_delayed_threads']),
      ( 'General',
        [ 'bootstrap',
          'chroot',
          'daemonize',
          'debug',
          'debug-sync-timeout',
          'div_precision_increment',
          'early-plugin-load',
          'exit-info',
          'flush',
          'flush_time',
          'init_connect',
          'init_slave',
          'initialize',
          'initialize-insecure',
          'max_digest_length',
          'max_error_count',
          'max_prepared_stmt_count',
          'max_sp_recursion_depth',
          'memlock',
          'min-examined-row-limit',
          'mutex-deadlock-detector',
          'old-style-user-limits',
          'open-files-limit',
          'restore_disables_events',
          'restore_elevation',
          'restore_precheck',
          'skip-concurrent-insert',
          'skip-thread-priority',
          'slow-start-timeout',
          'standalone',
          'sync_frm',
          'updatable_views_with_limit'])]),
  ( 'Other',
    [ ( 'X',
        [ 'mysqlx_port',
          'mysqlx_max_connections',
          'mysqlx_min_worker_threads',
          'mysqlx_idle_worker_thread_timeout',
          'mysqlx_max_allowed_packet',
          'mysqlx_connect_timeout',
          'mysqlx_ssl',
          'mysqlx_ssl_key',
          'mysqlx_ssl_ca',
          'mysqlx_ssl_capath',
          'mysqlx_ssl_cert',
          'mysqlx_ssl_cipher',
          'mysqlx_ssl_crl',
          'mysqlx_ssl_crlpath']),
      ( 'NDB',
        [ 'ndb-batch-size',
          'ndb-blob-read-batch-bytes',
          'ndb-blob-write-batch-bytes',
          'ndb-cluster-connection-pool',
          'ndb-cluster-connection-pool-nodeids',
          'ndb-connectstring',
          'ndb-log-transaction-id',
          'ndb-log-update-as-write',
          'ndb-mgmd-host',
          'ndb-nodeid',
          'ndb-recv-thread-activation-threshold',
          'ndb-recv-thread-cpu-mask',
          'ndb-wait-connected',
          'ndb-wait-setup',
          'ndb-allow-copying-alter-table',
          'ndb_autoincrement_prefetch_sz',
          'ndb_cache_check_time',
          'ndb_data_node_neighbour',
          'ndb_default_column_format',
          'ndb_deferred_constraints',
          'ndb_distribution',
          'ndb_eventbuffer_free_percent',
          'ndb_eventbuffer_max_alloc',
          'ndb_extra_logging',
          'ndb_force_send',
          'ndb_fully_replicated',
          'ndb_index_stat_cache_entries',
          'ndb_index_stat_enable',
          'ndb_index_stat_option',
          'ndb_index_stat_update_freq',
          'ndb_log_apply_status',
          'ndb_log_empty_epochs',
          'ndb_log_empty_update',
          'ndb_log_exclusive_reads',
          'ndb_log_orig',
          'ndb_log_updated_only',
          'ndb_optimized_node_selection',
          'ndb_read_backup',
          'ndb_report_thresh_binlog_epoch_slip',
          'ndb_report_thresh_binlog_mem_usage',
          'ndb_show_foreign_key_mock_tables',
          'ndb_slave_conflict_role',
          'ndb_use_transactions',
          'ndbcluster']),
      ( 'Memcached',
        [ 'daemon_memcached_enable_binlog',
          'daemon_memcached_engine_lib_name',
          'daemon_memcached_engine_lib_path',
          'daemon_memcached_option',
          'daemon_memcached_r_batch_size',
          'daemon_memcached_w_batch_size']),
      ( 'Storage Engines',
        ['skip-bdb', 'skip-falcon', 'skip-merge', 'skip-sync-bdb-logs'])]),
  ( 'Security',
    [ ( 'Security',
        [ 'allow-suspicious-udfs',
          'authentication_windows_log_level',
          'authentication_windows_use_principal_name',
          'auto_generate_certs',
          'block_encryption_mode',
          'des-key-file',
          'read_only',
          'require_secure_transport',
          'safe-mode',
          'safe-show-database',
          'safe-user-create',
          'safemalloc-mem-limit',
          'schema_definition_cache',
          'secure-auth',
          'secure-backup-file-priv',
          'secure-file-priv',
          'skip-grant-tables',
          'skip-show-database']),
      ( 'Authentication',
        [ 'default_authentication_plugin',
          'default_password_lifetime',
          'disconnect_on_expired_password',
          'mysql_native_password_proxy_users'])]),
  ( 'Replication',
    [ ( 'Relay Log',
        [ 'max_relay_log_size',
          'relay-log',
          'relay-log-info-repository',
          'relay_log_index',
          'relay_log_info_file',
          'relay_log_purge',
          'relay_log_recovery',
          'relay_log_space_limit',
          'sync_relay_log',
          'sync_relay_log_info']),
      ( 'Slave',
        [ 'abort-slave-event-count',
          'disconnect-slave-event-count',
          'init_slave',
          'rpl_stop_slave_timeout',
          'show-slave-auth-info',
          'slave-load-tmpdir',
          'slave-max-allowed-packet',
          'slave-net-timeout',
          'slave-parallel-type',
          'slave-parallel-workers',
          'slave-rows-search-algorithms',
          'slave-skip-errors',
          'slave-sql-verify-checksum',
          'slave_allow_batching',
          'slave_checkpoint_group',
          'slave_checkpoint_period',
          'slave_compressed_protocol',
          'slave_exec_mode',
          'slave_transaction_retries',
          'slave_type_conversions']),
      ( 'Master',
        [ 'master-connect-retry',
          'master-host',
          'master-info-file',
          'master-password',
          'master-port',
          'master-retry-count',
          'master-ssl',
          'master-ssl-ca',
          'master-ssl-capath',
          'master-ssl-cert',
          'master-ssl-cipher',
          'master-ssl-key',
          'master-user',
          'master-verify-checksum',
          'master_info_repository',
          'sync_master_info']),
      ( 'Group',
        [ 'group_replication_group_name',
          'group_replication_start_on_boot',
          'group_replication_local_address',
          'group_replication_group_seeds',
          'group_replication_force_members',
          'group_replication_bootstrap_group',
          'group_replication_poll_spin_loops',
          'group_replication_recovery_retry_count',
          'group_replication_recovery_reconnect_interval',
          'group_replication_recovery_use_ssl',
          'group_replication_recovery_ssl_ca',
          'group_replication_recovery_ssl_capath',
          'group_replication_recovery_ssl_cert',
          'group_replication_recovery_ssl_key',
          'group_replication_recovery_ssl_crl',
          'group_replication_recovery_ssl_crlpath',
          'group_replication_recovery_ssl_verify_server_cert',
          'group_replication_recovery_complete_at',
          'group_replication_components_stop_timeout',
          'group_replication_allow_local_lower_version_join',
          'group_replication_allow_local_disjoint_gtids_join',
          'group_replication_auto_increment_increment',
          'group_replication_compression_threshold',
          'group_replication_gtid_assignment_block_size',
          'group_replication_ssl_mode',
          'group_replication_single_primary_mode',
          'group_replication_enforce_update_everywhere_checks',
          'group_replication_flow_control_mode',
          'group_replication_flow_control_certifier_threshold',
          'group_replication_flow_control_applier_threshold',
          'group_replication_ip_whitelist']),
      ( 'General',
        [ 'disable_gtid_unsafe_statements',
          'enforce_gtid_consistency',
          'executed-gtids-compression-period',
          'gtid-mode',
          'init-rpl-role',
          'replicate-do-db',
          'replicate-do-table',
          'replicate-ignore-db',
          'replicate-ignore-table',
          'replicate-rewrite-db',
          'replicate-same-server-id',
          'replicate-wild-do-table',
          'replicate-wild-ignore-table',
          'report-host',
          'report-password',
          'report-port',
          'report-user',
          'skip-slave-start'])]),
  ( 'MyISAM',
    [ ( 'Advanced Settings',
        [ 'myisam-block-size',
          'myisam-recover',
          'myisam-recover-options',
          'myisam_data_pointer_size',
          'myisam_max_extra_sort_file_size',
          'myisam_max_sort_file_size',
          'myisam_mmap_size',
          'myisam_repair_threads',
          'myisam_sort_buffer_size',
          'myisam_stats_method',
          'myisam_use_mmap']),
      ( 'Fulltext search',
        [ 'ft_boolean_syntax',
          'ft_max_word_len',
          'ft_min_word_len',
          'ft_query_expansion_limit',
          'ft_stopword_file']),
      ( 'General',
        [ 'concurrent_insert',
          'keep_files_on_create',
          'key_buffer_size',
          'key_cache_age_threshold'])]),
  ( 'Performance',
    [ ( 'Query cache',
        [ 'query_cache_limit',
          'query_cache_min_res_unit',
          'query_cache_size',
          'query_cache_type',
          'query_cache_wlock_invalidate']),
      ( 'Optimizer',
        [ 'engine-condition-pushdown',
          'optimizer_join_cache_level',
          'optimizer_prune_level',
          'optimizer_search_depth',
          'optimizer_switch']),
      ( 'Performance Schema',
        [ 'performance-schema-consumer-events-stages-current',
          'performance-schema-consumer-events-stages-history',
          'performance-schema-consumer-events-stages-history-long',
          'performance-schema-consumer-events-statements-current',
          'performance-schema-consumer-events-statements-history',
          'performance-schema-consumer-events-statements-history-long',
          'performance-schema-consumer-events-transactions-current',
          'performance-schema-consumer-events-transactions-history',
          'performance-schema-consumer-events-transactions-history-long',
          'performance-schema-consumer-events-waits-current',
          'performance-schema-consumer-events-waits-history',
          'performance-schema-consumer-events-waits-history-long',
          'performance-schema-consumer-global-instrumentation',
          'performance-schema-consumer-statements-digest',
          'performance-schema-consumer-thread-instrumentation',
          'performance-schema-instrument',
          'performance_schema',
          'performance_schema_accounts_size',
          'performance_schema_digests_size',
          'performance_schema_error_size',
          'performance_schema_events_stages_history_long_size',
          'performance_schema_events_stages_history_size',
          'performance_schema_events_statements_history_long_size',
          'performance_schema_events_statements_history_size',
          'performance_schema_events_transactions_history_long_size',
          'performance_schema_events_transactions_history_size',
          'performance_schema_events_waits_history_long_size',
          'performance_schema_events_waits_history_size',
          'performance_schema_hosts_size',
          'performance_schema_max_cond_classes',
          'performance_schema_max_cond_instances',
          'performance_schema_max_digest_length',
          'performance_schema_max_file_classes',
          'performance_schema_max_file_handles',
          'performance_schema_max_file_instances',
          'performance_schema_max_index_stat',
          'performance_schema_max_memory_classes',
          'performance_schema_max_metadata_locks',
          'performance_schema_max_mutex_classes',
          'performance_schema_max_mutex_instances',
          'performance_schema_max_prepared_statements_instances',
          'performance_schema_max_program_instances',
          'performance_schema_max_rwlock_classes',
          'performance_schema_max_rwlock_instances',
          'performance_schema_max_socket_classes',
          'performance_schema_max_socket_instances',
          'performance_schema_max_sql_text_length',
          'performance_schema_max_stage_classes',
          'performance_schema_max_statement_classes',
          'performance_schema_max_statement_stack',
          'performance_schema_max_table_handles',
          'performance_schema_max_table_instances',
          'performance_schema_max_table_lock_stat',
          'performance_schema_max_thread_classes',
          'performance_schema_max_thread_instances',
          'performance_schema_session_connect_attrs_size',
          'performance_schema_setup_actors_size',
          'performance_schema_setup_objects_size',
          'performance_schema_users_size']),
      ( 'General',
        [ 'delay-key-write',
          'low-priority-updates',
          'profiling_history_size'])])]
