using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
using System.Drawing.Html;
using System.Globalization;

namespace System.Windows.Forms
{
    /// <summary>
    /// Provides HTML rendering on the text of the label
    /// </summary>
    public class HtmlLabel
        : HtmlPanel
    {
        #region Fields

        #endregion

        #region Ctor

        /// <summary>
        /// Creates a new HTML Label
        /// </summary>
        public HtmlLabel()
        {
          SetStyle(System.Windows.Forms.ControlStyles.Opaque, false);
          UpdateStyles(); // ml

          AutoScroll = false;
        }

        #endregion

        #region Properties

        [DefaultValue(true)]
        [Description("Automatically sets the size of the label by measuring the content")]
        [Browsable(true)]
        public override bool AutoSize
        {
            get
            {
                return base.AutoSize;
            }
            set
            {
                base.AutoSize = value;

                if (value)
                {
                    MeasureBounds();
                }
            }
        }

        #endregion

        #region Methods

        protected override void CreateFragment()
        {
          // ml: added culture neutral number conversion.
          // Number conversion must be done culture neutral.
          CultureInfo cultureInfo = new CultureInfo("en-US");
          string fontSize = Font.Size.ToString(cultureInfo);

          string font = string.Format("font: {0}pt {1}; ", fontSize, Font.FontFamily.Name);
          string padding = string.Format("padding: {0}px {1}px {2}px {3}px; ", Padding.Top, Padding.Right, Padding.Bottom, Padding.Left);

          // ml: use an html block element with fewest side effects. Let the caller define the space around the text.
          _htmlContainer = new InitialContainer("<div style=\"" + font + padding + "\">" + Text + "</div>");
        }

        public override void MeasureBounds()
        {
            base.MeasureBounds();

            if(_htmlContainer != null && AutoSize)
                Size = System.Drawing.Size.Round(_htmlContainer.MaximumSize);
        }

      // ml: added to act when the container font changes.
        protected override void OnFontChanged(EventArgs e)
        {
          base.OnFontChanged(e);
          CreateFragment();
        }

        #endregion
    }
}
