/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class SaveTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(4);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.tx.begin();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            if (i % 2 != 0) continue;
            arrayList.add(this.employees.get(i));
        }
        this.session.makePersistentAll(arrayList);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testSave() {
        Employee employee;
        int n;
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            if (employee != null) {
                if (n % 2 != 0) {
                    this.error("Employee " + n + " should not exist.");
                }
                employee.setAge(4 - n);
            } else if (n % 2 == 0) {
                this.error("Employee " + n + " should exist.");
            } else {
                employee = (Employee)this.employees.get(n);
                employee.setAge(4 - n);
            }
            this.session.savePersistent((Object)employee);
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            if (employee == null) {
                this.error("Failed save: employee " + n + " does not exist.");
                continue;
            }
            int n2 = 4 - n;
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed save: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testSaveAll() {
        Employee employee;
        int n;
        this.tx.begin();
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        ArrayList<Employee> arrayList2 = new ArrayList<Employee>();
        for (int i = 0; i < 4; ++i) {
            Employee employee2 = (Employee)this.session.find(Employee.class, (Object)i);
            if (employee2 != null) {
                if (i % 2 != 0) {
                    this.error("Employee " + i + " should not exist.");
                }
                employee2.setAge(4 - i);
            } else if (i % 2 == 0) {
                this.error("Employee " + i + " should exist.");
            } else {
                employee2 = (Employee)this.employees.get(i);
                employee2.setAge(4 - i);
            }
            arrayList.add(employee2);
            arrayList2.add(employee2);
        }
        List list = (List)this.session.savePersistentAll(arrayList);
        if (list.size() != 4) {
            this.error("Wrong size for saved employees. Expected: 4 actual: " + list.size());
        }
        for (n = 0; n < 4; ++n) {
            employee = (Employee)arrayList2.get(n);
            Employee employee3 = (Employee)list.get(n);
            if (employee3 == employee) continue;
            this.error("Failed saveAll: employee " + n + " did not match savedEmployees. Expected: " + employee.toString() + " hashcode: " + employee.hashCode() + " actual: " + employee3.toString() + " hashcode: " + employee3.hashCode());
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            if (employee == null) {
                this.error("Failed saveAll: employee " + n + " does not exist.");
                continue;
            }
            int n2 = 4 - n;
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed saveAll: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }
}

