/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.CharsetUtf8;
import testsuite.clusterj.model.IdBase;

public class QueryTextIndexScanTest
extends AbstractQueryTest {
    protected String constant = "0000000000";
    protected String change = "1111111111";
    protected String variable = "abcdefghij";
    protected CharsetUtf8[] instancesToUpdate = new CharsetUtf8[this.getNumberOfInstances()];

    @Override
    public Class<?> getInstanceType() {
        return CharsetUtf8.class;
    }

    @Override
    void createInstances(int n) {
        for (int i = 0; i < n; ++i) {
            CharsetUtf8 charsetUtf8 = (CharsetUtf8)this.session.newInstance(CharsetUtf8.class);
            charsetUtf8.setId(i);
            charsetUtf8.setLargeColumn(this.getCharacters(i));
            this.instances.add(charsetUtf8);
        }
    }

    public void test() {
        this.equalQuery("id", "PRIMARY", 5, 5);
        this.testUpdate(5);
        this.greaterEqualQuery("id", "PRIMARY", 7, 7, 8, 9);
        this.greaterThanQuery("id", "PRIMARY", 6, 7, 8, 9);
        this.testUpdate(7);
        this.lessEqualQuery("id", "PRIMARY", 4, 4, 3, 2, 1, 0);
        this.lessThanQuery("id", "PRIMARY", 4, 3, 2, 1, 0);
        this.betweenQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterEqualAndLessEqualQuery("id", "PRIMARY", 2, 4, 2, 3, 4);
        this.greaterThanAndLessEqualQuery("id", "PRIMARY", 2, 4, 3, 4);
        this.greaterEqualAndLessThanQuery("id", "PRIMARY", 2, 4, 2, 3);
        this.greaterThanAndLessThanQuery("id", "PRIMARY", 2, 4, 3);
        this.testDelete(5);
        this.testDelete(8);
        this.failOnError();
    }

    protected String getCharacters(int n) {
        return this.constant + this.variable.charAt(n);
    }

    protected void testUpdate(int n) {
        String string = this.change + this.variable.charAt(n);
        CharsetUtf8 charsetUtf8 = this.instancesToUpdate[n];
        charsetUtf8.setLargeColumn(string);
        this.session.updatePersistent((Object)charsetUtf8);
        CharsetUtf8 charsetUtf82 = (CharsetUtf8)this.session.find(CharsetUtf8.class, (Object)n);
        this.errorIfNotEqual("Mismatch on update " + n, string, charsetUtf82.getLargeColumn());
    }

    protected void testDelete(int n) {
        CharsetUtf8 charsetUtf8 = this.instancesToUpdate[n];
        this.session.deletePersistent((Object)charsetUtf8);
        CharsetUtf8 charsetUtf82 = (CharsetUtf8)this.session.find(CharsetUtf8.class, (Object)n);
        if (charsetUtf82 != null) {
            this.error("Failed to delete " + n + ".");
        }
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        CharsetUtf8 charsetUtf8 = (CharsetUtf8)idBase;
        int n = charsetUtf8.getId();
        this.instancesToUpdate[n] = charsetUtf8;
        this.errorIfNotEqual("Mismatch reading instance " + n, this.constant + this.variable.charAt(n), charsetUtf8.getLargeColumn());
    }
}

