/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.CharsetSwedishUtf8;
import testsuite.clusterj.model.IdBase;

public class FixedLengthCharTest
extends AbstractClusterJModelTest {
    static AbstractClusterJModelTest.ColumnDescriptor utf_column = new AbstractClusterJModelTest.ColumnDescriptor("utfcolumn", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((CharsetSwedishUtf8)idBase).setUtfColumn((String)object);
        }

        @Override
        public String getFieldValue(IdBase idBase) {
            return ((CharsetSwedishUtf8)idBase).getUtfColumn();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setString(n, (String)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }
    });
    static AbstractClusterJModelTest.ColumnDescriptor swedish_column = new AbstractClusterJModelTest.ColumnDescriptor("swedishcolumn", new AbstractClusterJModelTest.InstanceHandler(){

        @Override
        public void setFieldValue(IdBase idBase, Object object) {
            ((CharsetSwedishUtf8)idBase).setSwedishColumn((String)object);
        }

        @Override
        public String getFieldValue(IdBase idBase) {
            return ((CharsetSwedishUtf8)idBase).getSwedishColumn();
        }

        @Override
        public void setPreparedStatementValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
            preparedStatement.setString(n, (String)object);
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }
    });
    protected static AbstractClusterJModelTest.ColumnDescriptor[] columnDescriptors = new AbstractClusterJModelTest.ColumnDescriptor[]{utf_column, swedish_column};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(CharsetSwedishUtf8.class);
        try {
            this.tx.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addTearDownClasses(CharsetSwedishUtf8.class);
    }

    public void testUtf8() {
        this.writeRead(1, utf_column, "aaa");
        this.writeRead(2, utf_column, "aaaa");
        this.writeRead(3, utf_column, "aaaaaaaaaaaa");
        this.writeRead(4, utf_column, "\u20ac\u20ac\u20ac\u20ac");
        this.writeRead(5, utf_column, "aaaa  ", "aaaa");
        this.writeRead(6, utf_column, "\u20ac\u20ac\u20ac  ", "\u20ac\u20ac\u20ac");
        this.writeFail(20, utf_column, "aaaaaaaaaaaaa", ".*Data length 13 too long.*");
        this.failOnError();
    }

    public void testSwedish() {
        this.writeRead(7, swedish_column, "aaa");
        this.writeRead(8, swedish_column, "aaaa");
        this.writeRead(9, swedish_column, "aa  ", "aa");
        this.writeFail(21, swedish_column, "aaaaa", ".*Data length 5 too long..*");
        this.failOnError();
    }

    protected void writeRead(int n, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String string, String string2) {
        CharsetSwedishUtf8 charsetSwedishUtf8 = (CharsetSwedishUtf8)this.session.newInstance(CharsetSwedishUtf8.class);
        charsetSwedishUtf8.setId(n);
        columnDescriptor.setFieldValue(charsetSwedishUtf8, string);
        this.session.currentTransaction().begin();
        this.session.persist((Object)charsetSwedishUtf8);
        this.session.currentTransaction().commit();
        this.session.currentTransaction().begin();
        charsetSwedishUtf8 = (CharsetSwedishUtf8)this.session.find(CharsetSwedishUtf8.class, (Object)n);
        this.session.currentTransaction().commit();
        this.errorIfNotEqual("Failure on reading data from " + columnDescriptor.getColumnName(), string2, columnDescriptor.getFieldValue(charsetSwedishUtf8));
    }

    protected void writeRead(int n, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String string) {
        this.writeRead(n, columnDescriptor, string, string);
        this.queryAndVerifyResults(columnDescriptor.getColumnName() + " = " + string, columnDescriptors, columnDescriptor.getColumnName() + " = ?", new String[]{string}, n);
    }

    protected void writeFail(int n, AbstractClusterJModelTest.ColumnDescriptor columnDescriptor, String string, String string2) {
        block2: {
            CharsetSwedishUtf8 charsetSwedishUtf8 = (CharsetSwedishUtf8)this.session.newInstance(CharsetSwedishUtf8.class);
            try {
                columnDescriptor.setFieldValue(charsetSwedishUtf8, string);
            }
            catch (Exception exception) {
                if (exception.getMessage().matches(string2)) break block2;
                this.error(exception.getMessage());
            }
        }
    }

    @Override
    protected AbstractClusterJModelTest.ColumnDescriptor[] getColumnDescriptors() {
        return columnDescriptors;
    }

    @Override
    protected String getTableName() {
        return "charsetswedishutf8";
    }
}

