/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.ConversationSummary;

public class Bug17200163Test
extends AbstractClusterJModelTest {
    protected int NUMBER_TO_INSERT = 10;
    protected List<ConversationSummary> instances = new ArrayList<ConversationSummary>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createInstances(this.NUMBER_TO_INSERT);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(ConversationSummary.class);
        this.tx.commit();
        this.addTearDownClasses(ConversationSummary.class);
    }

    public void test() {
        this.insert();
        this.testQuery(0L, 4L, 6L);
        this.failOnError();
    }

    protected void insert() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int n = 0;
        for (int i = 0; i < this.NUMBER_TO_INSERT; ++i) {
            this.session.makePersistent((Object)this.instances.get(i));
            ++n;
        }
        this.tx.commit();
    }

    protected void testQuery(long l, long l2, long l3) {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(ConversationSummary.class);
        Predicate predicate = null;
        PredicateOperand predicateOperand = queryDomainType.get("sourceUserId");
        PredicateOperand predicateOperand2 = queryDomainType.param("filter_sourceUserId");
        predicate = predicateOperand.equal(predicateOperand2);
        PredicateOperand predicateOperand3 = queryDomainType.get("updatedAt");
        PredicateOperand predicateOperand4 = queryDomainType.param("filter_updatedAt1");
        predicate = predicate.and(predicateOperand3.greaterEqual(predicateOperand4));
        PredicateOperand predicateOperand5 = queryDomainType.get("updatedAt");
        PredicateOperand predicateOperand6 = queryDomainType.param("filter_updatedAt2");
        predicate = predicate.and(predicateOperand5.lessEqual(predicateOperand6));
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("filter_sourceUserId", (Object)l);
        query.setParameter("filter_updatedAt1", (Object)l2);
        query.setParameter("filter_updatedAt2", (Object)l3);
        query.setLimits(0L, 2L);
        query.setOrdering(Query.Ordering.DESCENDING, new String[]{"updatedAt"});
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(6L);
        arrayList.add(5L);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        List list = query.getResultList();
        for (ConversationSummary conversationSummary : list) {
            arrayList2.add(conversationSummary.getAnswererId());
        }
        this.errorIfNotEqual("Results of query with ordering and limits for ConversationSummary", arrayList, arrayList2);
    }

    protected void createInstances(int n) {
        for (int i = 0; i < n; ++i) {
            ConversationSummary conversationSummary = (ConversationSummary)this.session.newInstance(ConversationSummary.class);
            conversationSummary.setSourceUserId(0L);
            conversationSummary.setAnswererId(i);
            conversationSummary.setDestUserId(i);
            conversationSummary.setLastMessageById(i);
            conversationSummary.setQueryHistoryId(i);
            conversationSummary.setText("Text " + i);
            conversationSummary.setUpdatedAt(i);
            conversationSummary.setViewed(0 == i % 2);
            this.instances.add(conversationSummary);
        }
    }
}

