/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.ScanFilter;
import com.mysql.clusterj.core.store.ScanOperation;
import java.util.List;

public class InPredicateImpl
extends PredicateImpl {
    protected PropertyImpl property;
    protected ParameterImpl parameter;

    public InPredicateImpl(QueryDomainTypeImpl<?> queryDomainTypeImpl, PropertyImpl propertyImpl, ParameterImpl parameterImpl) {
        super(queryDomainTypeImpl);
        this.property = propertyImpl;
        this.parameter = parameterImpl;
        parameterImpl.setProperty(propertyImpl);
        propertyImpl.setComplexParameter();
    }

    @Override
    public void markParameters() {
        this.parameter.mark();
    }

    @Override
    public void unmarkParameters() {
        this.parameter.unmark();
    }

    @Override
    public void markBoundsForCandidateIndices(QueryExecutionContext queryExecutionContext, CandidateIndexImpl[] candidateIndexImplArray) {
        if (this.parameter.getParameterValue(queryExecutionContext) == null) {
            return;
        }
        this.property.markInBound(candidateIndexImplArray, this);
    }

    @Override
    public void markBoundsForCandidateIndices(CandidateIndexImpl[] candidateIndexImplArray) {
        this.property.markInBound(candidateIndexImplArray, this);
    }

    public int operationSetBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, int n, boolean bl) {
        if (bl) {
            return this.operationSetBound(queryExecutionContext, indexScanOperation, n, IndexScanOperation.BoundType.BoundEQ);
        }
        return this.operationSetBound(queryExecutionContext, indexScanOperation, n, IndexScanOperation.BoundType.BoundLE) + this.operationSetBound(queryExecutionContext, indexScanOperation, n, IndexScanOperation.BoundType.BoundGE);
    }

    public int operationSetUpperBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, int n) {
        return this.operationSetBound(queryExecutionContext, indexScanOperation, n, IndexScanOperation.BoundType.BoundGE);
    }

    public int operationSetLowerBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, int n) {
        return this.operationSetBound(queryExecutionContext, indexScanOperation, n, IndexScanOperation.BoundType.BoundLE);
    }

    private int operationSetBound(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, int n, IndexScanOperation.BoundType boundType) {
        Object object = this.parameter.getParameterValue(queryExecutionContext);
        if (object == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
        }
        if (object instanceof List) {
            List list = (List)object;
            Object e = list.get(n);
            if (logger.isDetailEnabled()) {
                logger.detail("InPredicateImpl.operationSetBound for " + this.property.fmd.getName() + " List index: " + n + " value: " + e + " boundType: " + (Object)((Object)boundType));
            }
            this.property.operationSetBounds(e, boundType, indexScanOperation);
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray[n];
            this.property.operationSetBounds(object2, boundType, indexScanOperation);
            if (logger.isDetailEnabled()) {
                logger.detail("InPredicateImpl.operationSetBound for " + this.property.fmd.getName() + "  array index: " + n + " value: " + object2 + " boundType: " + (Object)((Object)boundType));
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, object.getClass().getName(), "List<?> or Object[]"));
        }
        return BOTH_BOUNDS_SET;
    }

    public void operationSetAllBounds(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation) {
        Object object = this.parameter.getParameterValue(queryExecutionContext);
        int n = 0;
        if (object == null) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
        }
        if (object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                this.property.operationSetBounds(e, IndexScanOperation.BoundType.BoundEQ, indexScanOperation);
                if (logger.isDetailEnabled()) {
                    logger.detail("InPredicateImpl.operationSetAllBounds for List index: " + n + " value: " + e);
                }
                indexScanOperation.endBound(n++);
            }
        } else if (object.getClass().isArray()) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                this.property.operationSetBounds(object2, IndexScanOperation.BoundType.BoundEQ, indexScanOperation);
                if (logger.isDetailEnabled()) {
                    logger.detail("InPredicateImpl.operationSetAllBounds for array index: " + n + " value: " + object2);
                }
                indexScanOperation.endBound(n++);
            }
        } else {
            throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, object.getClass().getName(), "List<?> or Object[]"));
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext queryExecutionContext, ScanOperation scanOperation) {
        try {
            ScanFilter scanFilter = scanOperation.getScanFilter(queryExecutionContext);
            this.filterCmpValue(queryExecutionContext, scanOperation, scanFilter);
        }
        catch (ClusterJException clusterJException) {
            throw clusterJException;
        }
        catch (Exception exception) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), exception);
        }
    }

    @Override
    public void filterCmpValue(QueryExecutionContext queryExecutionContext, ScanOperation scanOperation, ScanFilter scanFilter) {
        try {
            scanFilter.begin(ScanFilter.Group.GROUP_OR);
            Object object = this.parameter.getParameterValue(queryExecutionContext);
            if (object == null) {
                throw new ClusterJUserException(local.message("ERR_Parameter_Cannot_Be_Null", (Object)"operator in", (Object)this.parameter.parameterName));
            }
            if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    this.property.filterCmpValue(t, ScanFilter.BinaryCondition.COND_EQ, scanFilter);
                }
            } else if (Object[].class.isAssignableFrom(object.getClass())) {
                Object[] objectArray;
                for (Object object2 : objectArray = (Object[])object) {
                    this.property.filterCmpValue(object2, ScanFilter.BinaryCondition.COND_EQ, scanFilter);
                }
            } else {
                throw new ClusterJUserException(local.message("ERR_Parameter_Wrong_Type", this.parameter.parameterName, object.getClass().getName(), "Iterable<?> or Object[]"));
            }
            scanFilter.end();
        }
        catch (ClusterJException clusterJException) {
            throw clusterJException;
        }
        catch (Exception exception) {
            throw new ClusterJException(local.message("ERR_Get_NdbFilter"), exception);
        }
    }

    public int getParameterSize(QueryExecutionContext queryExecutionContext) {
        Class<?> clazz;
        int n = 1;
        Object object = this.parameter.getParameterValue(queryExecutionContext);
        if (object instanceof List) {
            n = ((List)object).size();
        }
        if ((clazz = object.getClass()).isArray()) {
            if (!Object.class.isAssignableFrom(clazz.getComponentType())) {
                throw new ClusterJUserException(local.message("ERR_Wrong_Parameter_Type_For_In", (Object)this.property.fmd.getName()));
            }
            Object[] objectArray = (Object[])object;
            n = objectArray.length;
        }
        if (n > 4096) {
            throw new ClusterJUserException(local.message("ERR_Parameter_Too_Big_For_In", (Object)this.property.fmd.getName(), (Object)n));
        }
        return n;
    }

    @Override
    public boolean isUsable(QueryExecutionContext queryExecutionContext) {
        return this.parameter.getParameterValue(queryExecutionContext) != null;
    }
}

