/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.NdbRecordResultDataImpl;
import com.mysql.clusterj.tie.NdbRecordScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import java.util.ArrayList;
import java.util.List;

class NdbRecordScanResultDataImpl
extends NdbRecordResultDataImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordScanResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordScanResultDataImpl.class);
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    private final ClusterTransactionImpl clusterTransaction;
    private final NdbRecordScanOperationImpl scanOperation;
    private final NdbScanOperation ndbScanOperation;
    protected final long skip;
    protected final long limit;
    protected long recordCounter = 0L;
    private final boolean lockRecordsDuringScan;
    private List<NdbOperationConst> recordsLocked = new ArrayList<NdbOperationConst>();

    public NdbRecordScanResultDataImpl(ClusterTransactionImpl clusterTransactionImpl, NdbRecordScanOperationImpl ndbRecordScanOperationImpl, long l, long l2) {
        super(ndbRecordScanOperationImpl);
        this.clusterTransaction = clusterTransactionImpl;
        this.scanOperation = ndbRecordScanOperationImpl;
        this.ndbScanOperation = (NdbScanOperation)ndbRecordScanOperationImpl.ndbOperation;
        this.skip = l;
        this.limit = l2;
        this.lockRecordsDuringScan = this.ndbScanOperation.getLockMode() != 2;
    }

    private void executeIfRecordsLocked() {
        if (this.recordsLocked.size() != 0) {
            this.clusterTransaction.executeNoCommit(false, true);
            for (NdbOperationConst ndbOperationConst : this.recordsLocked) {
                NdbErrorConst ndbErrorConst = ndbOperationConst.getNdbError();
                if (ndbErrorConst.code() == 0) continue;
                String string = this.clusterTransaction.db.getNdbErrorDetail(ndbErrorConst);
                Utility.throwError(null, ndbErrorConst, string);
            }
            this.recordsLocked.clear();
        }
    }

    @Override
    public boolean next() {
        if (this.recordCounter >= this.limit) {
            this.executeIfRecordsLocked();
            this.ndbScanOperation.close(true, true);
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        block5: while (!bl) {
            int n = this.scanOperation.nextResultCopyOut(bl2, bl3);
            switch (n) {
                case 0: {
                    NdbOperationConst ndbOperationConst;
                    if (++this.recordCounter <= this.skip) continue block5;
                    if (this.lockRecordsDuringScan && (ndbOperationConst = this.scanOperation.lockCurrentTuple()) != null) {
                        this.recordsLocked.add(ndbOperationConst);
                    }
                    this.scanOperation.loadBlobValues();
                    return true;
                }
                case 1: {
                    this.executeIfRecordsLocked();
                    this.ndbScanOperation.close(true, true);
                    return false;
                }
                case 2: {
                    this.executeIfRecordsLocked();
                    bl2 = true;
                    continue block5;
                }
            }
            Utility.throwError(n, this.ndbScanOperation.getNdbError());
        }
        return true;
    }
}

