/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import java.util.Arrays;

class IndexImpl
implements Index {
    static final I18NHelper local = I18NHelper.getInstance(IndexImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexImpl.class);
    private String tableName;
    private String name;
    private int noOfColumns;
    private String[] columnNames;
    private boolean unique;
    private String internalName;

    public IndexImpl(NdbDictionary.IndexConst indexConst, String string) {
        this.internalName = indexConst.getName();
        this.tableName = indexConst.getTable();
        this.name = string;
        this.unique = indexConst.getType() == 3;
        this.noOfColumns = indexConst.getNoOfColumns();
        this.columnNames = new String[this.noOfColumns];
        for (int i = 0; i < this.noOfColumns; ++i) {
            String string2;
            this.columnNames[i] = string2 = indexConst.getColumn(i).getName();
        }
        if (logger.isDetailEnabled()) {
            logger.detail(this.toString());
        }
    }

    public IndexImpl(NdbDictionary.TableConst tableConst) {
        this.internalName = "PRIMARY";
        this.name = "PRIMARY";
        this.tableName = tableConst.getName();
        this.unique = true;
        this.noOfColumns = tableConst.getNoOfPrimaryKeys();
        this.columnNames = new String[this.noOfColumns];
        for (int i = 0; i < this.noOfColumns; ++i) {
            this.columnNames[i] = tableConst.getPrimaryKey(i);
        }
        if (logger.isDetailEnabled()) {
            logger.detail(this.toString());
        }
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String toString() {
        return "IndexImpl name: " + this.name + " internal name: " + this.internalName + " table: " + this.tableName + " unique: " + this.unique + " columns: " + Arrays.toString(this.columnNames);
    }
}

